/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.hologram.models.line;

import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import net.thenextlvl.hologram.line.BlockHologramLine;
import net.thenextlvl.hologram.line.EntityHologramLine;
import net.thenextlvl.hologram.line.HologramLine;
import net.thenextlvl.hologram.line.ItemHologramLine;
import net.thenextlvl.hologram.line.LineType;
import net.thenextlvl.hologram.line.PagedHologramLine;
import net.thenextlvl.hologram.line.TextHologramLine;
import net.thenextlvl.hologram.models.PaperHologram;
import net.thenextlvl.hologram.models.line.PaperBlockHologramLine;
import net.thenextlvl.hologram.models.line.PaperEntityHologramLine;
import net.thenextlvl.hologram.models.line.PaperHologramLine;
import net.thenextlvl.hologram.models.line.PaperItemHologramLine;
import net.thenextlvl.hologram.models.line.PaperStaticHologramLine;
import net.thenextlvl.hologram.models.line.PaperTextHologramLine;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class PaperPagedHologramLine
extends PaperHologramLine
implements PagedHologramLine {
    private final List<PaperStaticHologramLine<?>> pages = new CopyOnWriteArrayList();
    private final Map<Player, Integer> currentPageIndex = new ConcurrentHashMap<Player, Integer>();
    private final Random random = new Random();
    private volatile @Nullable ScheduledTask cycleTask = null;
    private volatile Duration interval = Duration.ofSeconds(2L);
    private volatile boolean paused = false;
    private volatile boolean randomOrder = false;

    public PaperPagedHologramLine(PaperHologram hologram) {
        super(hologram);
    }

    @Override
    public Optional<Entity> getEntity(Player player) {
        return this.getCurrentPage(player).flatMap(page -> page.getEntity(player));
    }

    @Override
    public <T> Optional<T> getEntity(Player player, Class<T> type) {
        return this.getEntity(player).filter(type::isInstance).map(type::cast);
    }

    @Override
    public Class<? extends Entity> getEntityClass() {
        return Entity.class;
    }

    @Override
    public EntityType getEntityType() {
        return EntityType.MARKER;
    }

    @Override
    public LineType getType() {
        return LineType.PAGED;
    }

    @Override
    public boolean isPart(Entity entity) {
        return this.pages.stream().anyMatch(page -> page.isPart(entity));
    }

    @Override
    public List<HologramLine> getPages() {
        return List.copyOf(this.pages);
    }

    @Override
    public Optional<HologramLine> getPage(int index) {
        if (index < 0 || index >= this.pages.size()) {
            return Optional.empty();
        }
        return Optional.of((HologramLine)this.pages.get(index));
    }

    @Override
    public <T extends HologramLine> Optional<T> getPage(int index, Class<T> type) {
        return this.getPage(index).filter(type::isInstance).map(type::cast);
    }

    @Override
    public int getPageCount() {
        return this.pages.size();
    }

    @Override
    public TextHologramLine addTextPage() {
        PaperTextHologramLine page = new PaperTextHologramLine(this.getHologram());
        this.pages.add(page);
        this.getHologram().updateHologram();
        return page;
    }

    @Override
    public ItemHologramLine addItemPage() {
        PaperItemHologramLine page = new PaperItemHologramLine(this.getHologram());
        this.pages.add(page);
        this.getHologram().updateHologram();
        return page;
    }

    @Override
    public BlockHologramLine addBlockPage() {
        PaperBlockHologramLine page = new PaperBlockHologramLine(this.getHologram());
        this.pages.add(page);
        this.getHologram().updateHologram();
        return page;
    }

    @Override
    public EntityHologramLine addEntityPage(EntityType entityType) throws IllegalArgumentException {
        Class entityClass = entityType.getEntityClass();
        if (entityClass == null) {
            throw new IllegalArgumentException("Entity type is not spawnable: " + String.valueOf(entityType));
        }
        PaperEntityHologramLine page = new PaperEntityHologramLine(this.getHologram(), entityClass);
        this.pages.add(page);
        this.getHologram().updateHologram();
        return page;
    }

    @Override
    public boolean removePage(int index) {
        if (index < 0 || index >= this.pages.size()) {
            return false;
        }
        PaperStaticHologramLine<?> removed = this.pages.remove(index);
        removed.despawn();
        return true;
    }

    @Override
    public boolean removePage(HologramLine page) {
        if (!(page instanceof PaperStaticHologramLine)) {
            return false;
        }
        PaperStaticHologramLine paperPage = (PaperStaticHologramLine)page;
        boolean removed = this.pages.remove(paperPage);
        if (removed) {
            paperPage.despawn();
        }
        return removed;
    }

    @Override
    public void clearPages() {
        this.pages.forEach(PaperStaticHologramLine::despawn);
        this.pages.clear();
        this.currentPageIndex.clear();
        this.stopCycleTask();
    }

    @Override
    public Duration getInterval() {
        return this.interval;
    }

    @Override
    public PagedHologramLine setInterval(Duration interval) {
        this.interval = interval;
        this.restartCycleTask();
        return this;
    }

    @Override
    public boolean isRandomOrder() {
        return this.randomOrder;
    }

    @Override
    public PagedHologramLine setRandomOrder(boolean random) {
        this.randomOrder = random;
        return this;
    }

    @Override
    public boolean isPaused() {
        return this.paused;
    }

    @Override
    public PagedHologramLine setPaused(boolean paused) {
        this.paused = paused;
        if (paused) {
            this.stopCycleTask();
        } else {
            this.restartCycleTask();
        }
        return this;
    }

    public Optional<HologramLine> getCurrentPage(Player player) {
        Integer index = this.currentPageIndex.getOrDefault(player, 0);
        return this.getPage(index);
    }

    public int getCurrentPageIndex(Player player) {
        return this.currentPageIndex.getOrDefault(player, 0);
    }

    @Override
    public double getHeight(Player player) {
        return this.getCurrentPage(player).map(PaperStaticHologramLine.class::cast).map(page -> page.getHeight(player)).orElse(0.0);
    }

    @Override
    public double getOffsetBefore(Player player) {
        return this.getCurrentPage(player).map(PaperStaticHologramLine.class::cast).map(page -> page.getOffsetBefore(player)).orElse(0.0);
    }

    @Override
    public double getOffsetAfter() {
        return this.pages.stream().mapToDouble(PaperHologramLine::getOffsetAfter).max().orElse(0.0);
    }

    @Override
    public @Nullable Entity spawn(Player player, double offset) {
        if (this.pages.isEmpty()) {
            return null;
        }
        this.currentPageIndex.put(player, 0);
        PaperStaticHologramLine<?> page = this.pages.getFirst();
        this.startCycleTask();
        return page.spawn(player, offset);
    }

    @Override
    public void despawn() {
        this.stopCycleTask();
        this.pages.forEach(PaperStaticHologramLine::despawn);
        this.currentPageIndex.clear();
    }

    @Override
    public void despawn(Player player) {
        this.currentPageIndex.remove(player);
        this.pages.forEach(page -> page.despawn(player));
    }

    @Override
    public CompletableFuture<Void> teleportRelative(Location previous, Location location) {
        return CompletableFuture.allOf((CompletableFuture[])this.pages.stream().map(page -> page.teleportRelative(previous, location)).toArray(CompletableFuture[]::new));
    }

    @Override
    public void invalidate(Entity entity) {
        this.pages.forEach(page -> page.invalidate(entity));
    }

    private void cyclePage(Player player, double offset) {
        Object entity;
        if (this.pages.isEmpty()) {
            return;
        }
        int oldIndex = this.currentPageIndex.getOrDefault(player, 0);
        PaperStaticHologramLine<?> oldPage = this.pages.size() > oldIndex ? this.pages.get(oldIndex) : null;
        int newIndex = this.randomOrder ? this.random.nextInt(this.pages.size()) : (oldIndex + 1) % this.pages.size();
        PaperStaticHologramLine<?> newPage = this.pages.get(newIndex);
        this.currentPageIndex.put(player, newIndex);
        if (oldPage == null) {
            newPage.spawn(player, offset);
            return;
        }
        if (oldPage.getEntityClass().equals(newPage.getEntityClass()) && (entity = oldPage.removeEntity(player)) != null && entity.isValid()) {
            newPage.adoptEntity(player, (Entity)entity);
            return;
        }
        oldPage.despawn(player);
        newPage.spawn(player, offset);
    }

    private void startCycleTask() {
        if (this.cycleTask != null || this.paused || this.pages.size() <= 1) {
            return;
        }
        this.cycleTask = this.getHologram().getPlugin().getServer().getAsyncScheduler().runAtFixedRate((Plugin)this.getHologram().getPlugin(), scheduledTask -> this.cycleAllPlayers(), this.interval.toMillis(), this.interval.toMillis(), TimeUnit.MILLISECONDS);
    }

    private void stopCycleTask() {
        ScheduledTask task = this.cycleTask;
        if (task != null) {
            task.cancel();
            this.cycleTask = null;
        }
    }

    private void restartCycleTask() {
        this.stopCycleTask();
        if (!this.paused && this.pages.size() > 1) {
            this.startCycleTask();
        }
    }

    private void cycleAllPlayers() {
        this.currentPageIndex.keySet().forEach(player -> {
            if (this.getHologram().isSpawned((Player)player)) {
                this.cyclePage((Player)player, this.calculateOffset((Player)player));
            }
        });
    }

    private double calculateOffset(Player player) {
        double offset = 0.0;
        List<HologramLine> lines = this.getHologram().getLines().toList();
        for (int i = lines.size() - 1; i >= 0; --i) {
            HologramLine line = lines.get(i);
            if (line == this) {
                return offset;
            }
            if (!(line instanceof PaperStaticHologramLine)) continue;
            PaperStaticHologramLine paperLine = (PaperStaticHologramLine)line;
            offset += 0.05 + paperLine.getHeight(player) + paperLine.getOffsetAfter();
        }
        return offset;
    }

    public void addPage(PaperStaticHologramLine<?> hologramLine) {
        this.pages.add(hologramLine);
    }
}

