/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.hologram.models.line;

import java.util.Objects;
import net.thenextlvl.hologram.line.ItemHologramLine;
import net.thenextlvl.hologram.line.LineType;
import net.thenextlvl.hologram.models.PaperHologram;
import net.thenextlvl.hologram.models.line.PaperDisplayHologramLine;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.ItemType;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class PaperItemHologramLine
extends PaperDisplayHologramLine<ItemDisplay>
implements ItemHologramLine {
    private volatile ItemDisplay.ItemDisplayTransform displayTransform = ItemDisplay.ItemDisplayTransform.NONE;
    private volatile @Nullable ItemStack item = null;

    public PaperItemHologramLine(PaperHologram hologram) {
        super(hologram, ItemDisplay.class);
    }

    @Override
    public LineType getType() {
        return LineType.ITEM;
    }

    @Override
    public ItemStack getItemStack() {
        ItemStack itemStack = this.item;
        return itemStack != null ? itemStack.clone() : ItemType.AIR.createItemStack();
    }

    @Override
    public ItemHologramLine setItemStack(@Nullable ItemStack item) {
        this.item = item != null ? item.clone() : null;
        this.forEachEntity(entity -> entity.setItemStack(item));
        return this;
    }

    @Override
    public ItemDisplay.ItemDisplayTransform getItemDisplayTransform() {
        return this.displayTransform;
    }

    @Override
    public ItemHologramLine setItemDisplayTransform(ItemDisplay.ItemDisplayTransform display) {
        if (Objects.equals(this.displayTransform, display)) {
            return this;
        }
        this.displayTransform = display;
        this.forEachEntity(entity -> entity.setItemDisplayTransform(display));
        this.getHologram().updateHologram();
        return this;
    }

    @Override
    public double getHeight(Player player) {
        return (switch (this.displayTransform) {
            default -> throw new MatchException(null, null);
            case ItemDisplay.ItemDisplayTransform.NONE, ItemDisplay.ItemDisplayTransform.HEAD, ItemDisplay.ItemDisplayTransform.GUI -> 1.0;
            case ItemDisplay.ItemDisplayTransform.GROUND, ItemDisplay.ItemDisplayTransform.THIRDPERSON_LEFTHAND, ItemDisplay.ItemDisplayTransform.THIRDPERSON_RIGHTHAND, ItemDisplay.ItemDisplayTransform.FIRSTPERSON_LEFTHAND, ItemDisplay.ItemDisplayTransform.FIRSTPERSON_RIGHTHAND -> 0.45;
            case ItemDisplay.ItemDisplayTransform.FIXED -> 0.5;
        }) * (double)this.transformation.getScale().y();
    }

    @Override
    public double getOffsetBefore(Player player) {
        if (this.displayTransform == ItemDisplay.ItemDisplayTransform.GROUND) {
            return 0.0;
        }
        return this.getHeight(player) / 2.0;
    }

    @Override
    protected void preSpawn(ItemDisplay entity, Player player) {
        entity.setItemStack(this.item);
        entity.setItemDisplayTransform(this.displayTransform);
        super.preSpawn(entity, player);
    }
}

