/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.hologram.listeners;

import net.thenextlvl.hologram.HologramPlugin;
import net.thenextlvl.hologram.locale.MiniPlaceholdersFormatter;
import net.thenextlvl.hologram.locale.PlaceholderAPIFormatter;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.server.PluginEnableEvent;
import org.bukkit.plugin.Plugin;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class PluginListener
implements Listener {
    private final HologramPlugin plugin;

    public PluginListener(HologramPlugin plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPluginEnable(PluginEnableEvent event) {
        if (this.isPlugin(event.getPlugin(), "PlaceholderAPI")) {
            this.plugin.papiFormatter = new PlaceholderAPIFormatter();
            this.plugin.getComponentLogger().info("PlaceholderAPI detected, using for placeholders");
        }
        if (this.isPlugin(event.getPlugin(), "MiniPlaceholders")) {
            this.plugin.miniFormatter = new MiniPlaceholdersFormatter();
            this.plugin.getComponentLogger().info("MiniPlaceholders detected, using for placeholders");
        }
    }

    private boolean isPlugin(Plugin plugin, String name) {
        return plugin.getName().equals(name) || plugin.getPluginMeta().getProvidedPlugins().contains(name);
    }
}

