/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.hologram.commands.suggestions;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.MessageComponentSerializer;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.translation.Translatable;
import net.thenextlvl.hologram.Hologram;
import net.thenextlvl.hologram.line.BlockHologramLine;
import net.thenextlvl.hologram.line.EntityHologramLine;
import net.thenextlvl.hologram.line.HologramLine;
import net.thenextlvl.hologram.line.ItemHologramLine;
import net.thenextlvl.hologram.line.PagedHologramLine;
import net.thenextlvl.hologram.line.TextHologramLine;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class PageSuggestionProvider
implements SuggestionProvider<CommandSourceStack> {
    public static final PageSuggestionProvider INSTANCE = new PageSuggestionProvider();

    public CompletableFuture<Suggestions> getSuggestions(CommandContext<CommandSourceStack> context, SuggestionsBuilder builder) {
        int lineIndex;
        Hologram hologram = (Hologram)context.getLastChild().getArgument("hologram", Hologram.class);
        Optional<PagedHologramLine> line = hologram.getLine(lineIndex = (Integer)context.getLastChild().getArgument("line", Integer.TYPE) - 1, PagedHologramLine.class);
        if (line.isEmpty()) {
            return builder.buildFuture();
        }
        PagedHologramLine pagedLine = line.get();
        List<HologramLine> pages = pagedLine.getPages();
        for (int index = 1; index <= pages.size(); ++index) {
            String page = String.valueOf(index);
            if (!page.contains(builder.getRemaining())) continue;
            builder.suggest(page, PageSuggestionProvider.getTooltip(pages.get(index - 1)));
        }
        return builder.buildFuture();
    }

    private static Message getTooltip(HologramLine page) {
        HologramLine hologramLine = page;
        Objects.requireNonNull(hologramLine);
        HologramLine hologramLine2 = hologramLine;
        int n = 0;
        TextComponent tooltip = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BlockHologramLine.class, EntityHologramLine.class, ItemHologramLine.class, TextHologramLine.class}, (Object)hologramLine2, n)) {
            case 0 -> {
                BlockHologramLine blockLine = (BlockHologramLine)hologramLine2;
                yield (TextComponent)Component.text((String)"Block: ").append((Component)Component.translatable((Translatable)blockLine.getBlock().getMaterial()));
            }
            case 1 -> {
                EntityHologramLine entityLine = (EntityHologramLine)hologramLine2;
                yield (TextComponent)Component.text((String)"Entity: ").append((Component)Component.translatable((Translatable)entityLine.getEntityType()));
            }
            case 2 -> {
                ItemHologramLine itemLine = (ItemHologramLine)hologramLine2;
                yield (TextComponent)Component.text((String)"Item: ").append((Component)Component.translatable((Translatable)itemLine.getItemStack().getType()));
            }
            case 3 -> {
                TextHologramLine textLine = (TextHologramLine)hologramLine2;
                yield textLine.getUnparsedText().map(component -> MiniMessage.miniMessage().deserialize((Object)("Text: " + component.replace("\n", "\\n")))).orElse((Component)Component.empty());
            }
            default -> Component.text((String)"Unknown");
        };
        return (Message)MessageComponentSerializer.message().serialize((Component)tooltip);
    }
}

