/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.hologram.commands.page.edit;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import io.papermc.paper.command.brigadier.argument.ArgumentTypes;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.minimessage.tag.resolver.Formatter;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.thenextlvl.hologram.Hologram;
import net.thenextlvl.hologram.HologramPlugin;
import net.thenextlvl.hologram.commands.brigadier.BrigadierCommand;
import net.thenextlvl.hologram.commands.suggestions.PageSuggestionProvider;
import net.thenextlvl.hologram.line.BlockHologramLine;
import net.thenextlvl.hologram.line.HologramLine;
import net.thenextlvl.hologram.line.ItemHologramLine;
import net.thenextlvl.hologram.line.PagedHologramLine;
import net.thenextlvl.hologram.line.TextHologramLine;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.BlockData;
import org.bukkit.inventory.ItemStack;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class HologramPageEditSetCommand
extends BrigadierCommand {
    private HologramPageEditSetCommand(HologramPlugin plugin) {
        super(plugin, "set", "holograms.command.page.edit.set");
    }

    public static LiteralArgumentBuilder<CommandSourceStack> create(HologramPlugin plugin) {
        HologramPageEditSetCommand command = new HologramPageEditSetCommand(plugin);
        RequiredArgumentBuilder page = Commands.argument((String)"page", (ArgumentType)IntegerArgumentType.integer((int)1)).suggests((SuggestionProvider)PageSuggestionProvider.INSTANCE);
        return (LiteralArgumentBuilder)command.create().then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)page.then(command.setPage("block", ArgumentTypes.blockState(), (Command<CommandSourceStack>)((Command)command::setBlockPage)))).then(command.setPage("item", ArgumentTypes.itemStack(), (Command<CommandSourceStack>)((Command)command::setItemPage)))).then(command.setPage("text", (ArgumentType<?>)StringArgumentType.greedyString(), (Command<CommandSourceStack>)((Command)command::setTextPage))));
    }

    private LiteralArgumentBuilder<CommandSourceStack> setPage(String name, ArgumentType<?> argumentType, Command<CommandSourceStack> command) {
        return (LiteralArgumentBuilder)Commands.literal((String)name).then(Commands.argument((String)name, argumentType).executes(command));
    }

    private int setBlockPage(CommandContext<CommandSourceStack> context) {
        BlockData block = ((BlockState)context.getArgument("block", BlockState.class)).getBlockData();
        return this.setPage(context, BlockHologramLine.class, (T page) -> page.setBlock(block));
    }

    private int setItemPage(CommandContext<CommandSourceStack> context) {
        ItemStack item = (ItemStack)context.getArgument("item", ItemStack.class);
        return this.setPage(context, ItemHologramLine.class, (T page) -> page.setItemStack(item));
    }

    private int setTextPage(CommandContext<CommandSourceStack> context) {
        String text = (String)context.getArgument("text", String.class);
        return this.setPage(context, TextHologramLine.class, (T page) -> page.setUnparsedText(text));
    }

    private <T extends HologramLine> int setPage(CommandContext<CommandSourceStack> context, Class<T> type, Consumer<T> consumer) {
        Hologram hologram = (Hologram)context.getArgument("hologram", Hologram.class);
        int lineIndex = (Integer)context.getArgument("line", Integer.TYPE) - 1;
        int pageIndex = (Integer)context.getArgument("page", Integer.TYPE) - 1;
        Optional<PagedHologramLine> line = hologram.getLine(lineIndex, PagedHologramLine.class);
        if (line.isEmpty()) {
            this.plugin.bundle().sendMessage((Audience)((CommandSourceStack)context.getSource()).getSender(), "hologram.type.paged");
            return 0;
        }
        PagedHologramLine pagedLine = line.get();
        List<HologramLine> pages = pagedLine.getPages();
        if (pageIndex < 0 || pageIndex >= pages.size()) {
            this.plugin.bundle().sendMessage((Audience)((CommandSourceStack)context.getSource()).getSender(), "hologram.page.invalid", new TagResolver[]{Placeholder.unparsed((String)"hologram", (String)hologram.getName()), Formatter.number((String)"line", (Number)(lineIndex + 1)), Formatter.number((String)"page", (Number)(pageIndex + 1))});
            return 0;
        }
        HologramLine page = pages.get(pageIndex);
        if (!type.isInstance(page)) {
            this.plugin.bundle().sendMessage((Audience)((CommandSourceStack)context.getSource()).getSender(), "hologram.page.type.mismatch", new TagResolver[]{Placeholder.unparsed((String)"hologram", (String)hologram.getName()), Formatter.number((String)"line", (Number)(lineIndex + 1)), Formatter.number((String)"page", (Number)(pageIndex + 1))});
            return 0;
        }
        consumer.accept((HologramLine)type.cast(page));
        this.plugin.bundle().sendMessage((Audience)((CommandSourceStack)context.getSource()).getSender(), "hologram.page.set", new TagResolver[]{Placeholder.unparsed((String)"hologram", (String)hologram.getName()), Formatter.number((String)"line", (Number)(lineIndex + 1)), Formatter.number((String)"page", (Number)(pageIndex + 1))});
        return 1;
    }
}

