/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.hologram.commands.line.edit;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import io.papermc.paper.command.brigadier.argument.ArgumentTypes;
import java.util.Objects;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.minimessage.tag.resolver.Formatter;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.thenextlvl.hologram.Hologram;
import net.thenextlvl.hologram.HologramPlugin;
import net.thenextlvl.hologram.commands.brigadier.SimpleCommand;
import net.thenextlvl.hologram.line.StaticHologramLine;
import org.jspecify.annotations.NullMarked;

@NullMarked
final class HologramLineEditGlowColorCommand
extends SimpleCommand {
    private HologramLineEditGlowColorCommand(HologramPlugin plugin) {
        super(plugin, "glow-color", "holograms.command.line.edit.glow-color");
    }

    public static LiteralArgumentBuilder<CommandSourceStack> create(HologramPlugin plugin) {
        HologramLineEditGlowColorCommand command = new HologramLineEditGlowColorCommand(plugin);
        RequiredArgumentBuilder named = Commands.argument((String)"color", (ArgumentType)ArgumentTypes.namedColor());
        RequiredArgumentBuilder hex = Commands.argument((String)"hex", (ArgumentType)ArgumentTypes.hexColor());
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)command.create().then(named.executes((Command)command))).then(hex.executes((Command)command))).then(Commands.literal((String)"reset").executes((Command)command));
    }

    public int run(CommandContext<CommandSourceStack> context) {
        Hologram hologram = (Hologram)context.getArgument("hologram", Hologram.class);
        Integer line = (Integer)context.getArgument("line", Integer.TYPE);
        TextColor color = this.tryGetArgument(context, "hex", TextColor.class).or(() -> this.tryGetArgument(context, "color", NamedTextColor.class)).orElse(null);
        String message = hologram.getLine(line - 1, StaticHologramLine.class).map(hologramLine -> {
            if (Objects.equals(hologramLine.getGlowColor().orElse(null), color)) {
                return "nothing.changed";
            }
            hologramLine.setGlowColor(color);
            return color != null ? "hologram.line.glow-color" : "hologram.line.glow-color.reset";
        }).orElse("hologram.type.single");
        this.plugin.bundle().sendMessage((Audience)((CommandSourceStack)context.getSource()).getSender(), message, new TagResolver[]{Placeholder.unparsed((String)"hologram", (String)hologram.getName()), Formatter.number((String)"line", (Number)line)});
        return 1;
    }
}

