/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.hologram.commands.line.edit;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.minimessage.tag.resolver.Formatter;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.thenextlvl.hologram.Hologram;
import net.thenextlvl.hologram.HologramPlugin;
import net.thenextlvl.hologram.commands.arguments.EnumArgumentType;
import net.thenextlvl.hologram.commands.brigadier.SimpleCommand;
import net.thenextlvl.hologram.line.DisplayHologramLine;
import net.thenextlvl.i18n.ComponentBundle;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Display;
import org.jspecify.annotations.NullMarked;

@NullMarked
final class HologramLineEditBillboardCommand
extends SimpleCommand {
    private HologramLineEditBillboardCommand(HologramPlugin plugin) {
        super(plugin, "billboard", "holograms.command.line.edit.billboard");
    }

    public static LiteralArgumentBuilder<CommandSourceStack> create(HologramPlugin plugin) {
        HologramLineEditBillboardCommand command = new HologramLineEditBillboardCommand(plugin);
        RequiredArgumentBuilder named = Commands.argument((String)"billboard", new EnumArgumentType<Display.Billboard>(Display.Billboard.class));
        return (LiteralArgumentBuilder)command.create().then(named.executes((Command)command));
    }

    public int run(CommandContext<CommandSourceStack> context) {
        CommandSender sender = ((CommandSourceStack)context.getSource()).getSender();
        Hologram hologram = (Hologram)context.getArgument("hologram", Hologram.class);
        Integer line = (Integer)context.getArgument("line", Integer.TYPE);
        Display.Billboard billboard = (Display.Billboard)context.getArgument("billboard", Display.Billboard.class);
        String message = hologram.getLine(line - 1, DisplayHologramLine.class).map(textLine -> {
            if (textLine.getBillboard() == billboard) {
                return "nothing.changed";
            }
            textLine.setBillboard(billboard);
            return "hologram.billboard";
        }).orElse("hologram.type.display");
        ComponentBundle componentBundle = this.plugin.bundle();
        Component billboardName = componentBundle.component(switch (billboard) {
            default -> throw new MatchException(null, null);
            case Display.Billboard.FIXED -> "billboard.fixed";
            case Display.Billboard.VERTICAL -> "billboard.vertical";
            case Display.Billboard.HORIZONTAL -> "billboard.horizontal";
            case Display.Billboard.CENTER -> "billboard.center";
        }, (Audience)sender);
        this.plugin.bundle().sendMessage((Audience)sender, message, new TagResolver[]{Placeholder.unparsed((String)"hologram", (String)hologram.getName()), Placeholder.component((String)"billboard", (ComponentLike)billboardName), Formatter.number((String)"line", (Number)line)});
        return 1;
    }
}

