/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.hologram.models.line;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.thenextlvl.hologram.line.HologramLine;
import net.thenextlvl.hologram.models.PaperHologram;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scoreboard.Team;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public abstract class PaperHologramLine<E extends Entity>
implements HologramLine<E> {
    private final PaperHologram hologram;
    private final Class<E> entityClass;
    private final EntityType entityType;
    private final Map<Player, E> entities = new ConcurrentHashMap<Player, E>();
    protected volatile @Nullable TextColor glowColor = null;
    protected volatile boolean glowing = false;

    public PaperHologramLine(PaperHologram hologram, Class<E> entityClass) {
        this.hologram = hologram;
        this.entityType = Arrays.stream(EntityType.values()).filter(type -> type.getEntityClass() != null).filter(type -> type.getEntityClass().isAssignableFrom(entityClass)).findAny().orElseThrow(() -> new IllegalArgumentException("Entity type not found for " + String.valueOf(entityClass)));
        this.entityClass = entityClass;
    }

    @Override
    public Class<E> getTypeClass() {
        return this.entityClass;
    }

    @Override
    public EntityType getEntityType() {
        return this.entityType;
    }

    @Override
    public PaperHologram getHologram() {
        return this.hologram;
    }

    @Override
    public Optional<E> getEntity(Player player) {
        return Optional.ofNullable((Entity)this.getEntities().get(player));
    }

    public Map<Player, E> getEntities() {
        return this.entities;
    }

    @Override
    public <T> Optional<T> getEntity(Player player, Class<T> type) {
        return this.getEntity(player).filter(type::isInstance).map(type::cast);
    }

    @Override
    public World getWorld() {
        return this.hologram.getWorld();
    }

    @Override
    public Optional<TextColor> getGlowColor() {
        return Optional.ofNullable(this.glowColor);
    }

    @Override
    public HologramLine<E> setGlowColor(@Nullable TextColor color) {
        if (Objects.equals(this.glowColor, color)) {
            return this;
        }
        this.glowColor = color;
        this.updateGlowColor(color);
        return this;
    }

    protected abstract void updateGlowColor(@Nullable TextColor var1);

    protected void updateTeamOptions(Player player, Entity entity) {
        Team team = this.getSettingsTeam(player, entity);
        team.color((NamedTextColor)this.getGlowColor().map(NamedTextColor::nearestTo).orElse(null));
        team.setOption(Team.Option.COLLISION_RULE, Team.OptionStatus.NEVER);
        team.setOption(Team.Option.NAME_TAG_VISIBILITY, Team.OptionStatus.NEVER);
    }

    private Team getSettingsTeam(Player player, Entity entity) {
        Team settings = player.getScoreboard().getTeam(entity.getScoreboardEntryName());
        if (settings != null) {
            return settings;
        }
        settings = player.getScoreboard().registerNewTeam(entity.getScoreboardEntryName());
        settings.addEntry(entity.getScoreboardEntryName());
        return settings;
    }

    @Override
    public boolean isGlowing() {
        return this.glowing;
    }

    @Override
    public HologramLine<E> setGlowing(boolean glowing) {
        if (glowing == this.glowing) {
            return this;
        }
        this.glowing = glowing;
        this.getEntities().values().forEach(entity -> entity.setGlowing(glowing));
        return this;
    }

    public void despawn() {
        this.entities.values().removeIf(entity -> {
            entity.remove();
            return true;
        });
    }

    public void despawn(Player player) {
        Entity remove = (Entity)this.entities.remove(player);
        if (remove != null) {
            remove.remove();
        }
    }

    public abstract double getHeight(Player var1);

    public double getOffsetBefore(Player player) {
        return 0.0;
    }

    public double getOffsetAfter() {
        return 0.0;
    }

    public E spawn(Player player, double offset) throws IllegalStateException {
        return (E)this.entities.compute(player, (p, existing) -> {
            Preconditions.checkState((existing == null || !existing.isValid() ? 1 : 0) != 0, (Object)"Entity is already spawned");
            Location location = this.mutateSpawnLocation(this.hologram.getLocation().add(0.0, offset, 0.0));
            Entity spawn = location.getWorld().spawn(location, this.getTypeClass(), false, e -> this.preSpawn(e, player));
            player.showEntity((Plugin)this.hologram.getPlugin(), spawn);
            return spawn;
        });
    }

    protected Location mutateSpawnLocation(Location location) {
        return location;
    }

    public CompletableFuture<Void> teleportRelative(Location previous, Location location) {
        return CompletableFuture.allOf((CompletableFuture[])this.getEntities().values().stream().filter(Entity::isValid).map(entity -> entity.teleportAsync(new Location(location.getWorld(), location.getX() + entity.getX() - previous.getX(), location.getY() + entity.getY() - previous.getY(), location.getZ() + entity.getZ() - previous.getZ(), location.getYaw(), location.getPitch()))).toArray(CompletableFuture[]::new));
    }

    protected void preSpawn(E entity, Player player) {
        this.updateTeamOptions(player, (Entity)entity);
        entity.setGlowing(this.glowing);
        entity.setPersistent(false);
        entity.setVisibleByDefault(false);
    }

    private @Nullable Player remove(Entity entity) {
        Iterator<Map.Entry<Player, E>> iterator = this.entities.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Player, E> entry = iterator.next();
            if (!((Entity)entry.getValue()).equals((Object)entity)) continue;
            iterator.remove();
            return entry.getKey();
        }
        return null;
    }

    public void invalidate(Entity entity) {
        Player owner = this.remove(entity);
        if (owner == null) {
            return;
        }
        Team team = owner.getScoreboard().getTeam(entity.getScoreboardEntryName());
        if (team != null) {
            team.unregister();
        }
    }
}

