/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.hologram.models.line;

import java.util.Objects;
import java.util.Optional;
import net.kyori.adventure.text.format.TextColor;
import net.thenextlvl.hologram.line.DisplayHologramLine;
import net.thenextlvl.hologram.models.PaperHologram;
import net.thenextlvl.hologram.models.line.PaperHologramLine;
import org.bukkit.Color;
import org.bukkit.entity.Display;
import org.bukkit.entity.Player;
import org.bukkit.util.Transformation;
import org.joml.AxisAngle4f;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public abstract class PaperDisplayHologramLine<T extends DisplayHologramLine<T, E>, E extends Display>
extends PaperHologramLine<E>
implements DisplayHologramLine<T, E> {
    protected volatile // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable Display.Brightness brightness = null;
    protected volatile Display.Billboard billboard = Display.Billboard.CENTER;
    protected volatile Transformation transformation = new Transformation(new Vector3f(), new AxisAngle4f(), new Vector3f(1.0f), new AxisAngle4f());
    protected volatile float displayHeight = 0.0f;
    protected volatile float displayWidth = 0.0f;
    protected volatile float shadowRadius = 0.0f;
    protected volatile float shadowStrength = 1.0f;
    protected volatile float viewRange = 1.0f;
    protected volatile int interpolationDelay = 0;
    protected volatile int interpolationDuration = 0;
    protected volatile int teleportDuration = 4;

    public PaperDisplayHologramLine(PaperHologram hologram, Class<E> entityClass) {
        super(hologram, entityClass);
    }

    @Override
    public Transformation getTransformation() {
        return new Transformation(this.transformation.getTranslation(), this.transformation.getLeftRotation(), this.transformation.getScale(), this.transformation.getRightRotation());
    }

    @Override
    public T setTransformation(Transformation transformation) {
        if (Objects.equals(this.transformation, transformation)) {
            return this.getSelf();
        }
        this.transformation = new Transformation(new Vector3f((Vector3fc)transformation.getTranslation()), new AxisAngle4f((Quaternionfc)transformation.getLeftRotation()), new Vector3f((Vector3fc)transformation.getScale()), new AxisAngle4f((Quaternionfc)transformation.getRightRotation()));
        this.getEntities().values().forEach(entity -> entity.setTransformation(transformation));
        this.getHologram().updateHologram();
        return this.getSelf();
    }

    @Override
    public T setTransformationMatrix(Matrix4f transformationMatrix) {
        this.transformation = new Transformation(transformationMatrix.getTranslation(new Vector3f()), transformationMatrix.getRotation(new AxisAngle4f()), transformationMatrix.getScale(new Vector3f()), transformationMatrix.getRotation(new AxisAngle4f()));
        this.getEntities().values().forEach(entity -> entity.setTransformationMatrix(transformationMatrix));
        this.getHologram().updateHologram();
        return this.getSelf();
    }

    @Override
    public int getInterpolationDuration() {
        return this.interpolationDuration;
    }

    @Override
    public T setInterpolationDuration(int duration) {
        if (duration == this.interpolationDuration) {
            return this.getSelf();
        }
        this.interpolationDuration = duration;
        this.getEntities().values().forEach(entity -> entity.setInterpolationDuration(duration));
        return this.getSelf();
    }

    @Override
    public int getTeleportDuration() {
        return this.teleportDuration;
    }

    @Override
    public T setTeleportDuration(int duration) {
        if (duration == this.teleportDuration) {
            return this.getSelf();
        }
        this.teleportDuration = duration;
        this.getEntities().values().forEach(entity -> entity.setTeleportDuration(duration));
        return this.getSelf();
    }

    @Override
    public float getViewRange() {
        return this.viewRange;
    }

    @Override
    public T setViewRange(float range) {
        if (range == this.viewRange) {
            return this.getSelf();
        }
        this.viewRange = range;
        this.getEntities().values().forEach(entity -> entity.setViewRange(range));
        return this.getSelf();
    }

    @Override
    public float getShadowRadius() {
        return this.shadowRadius;
    }

    @Override
    public T setShadowRadius(float radius) {
        if (radius == this.shadowRadius) {
            return this.getSelf();
        }
        this.shadowRadius = radius;
        this.getEntities().values().forEach(entity -> entity.setShadowRadius(radius));
        return this.getSelf();
    }

    @Override
    public float getShadowStrength() {
        return this.shadowStrength;
    }

    @Override
    public T setShadowStrength(float strength) {
        if (strength == this.shadowStrength) {
            return this.getSelf();
        }
        this.shadowStrength = strength;
        this.getEntities().values().forEach(entity -> entity.setShadowStrength(strength));
        return this.getSelf();
    }

    @Override
    public float getDisplayWidth() {
        return this.displayWidth;
    }

    @Override
    public T setDisplayWidth(float width) {
        if (width == this.displayWidth) {
            return this.getSelf();
        }
        this.displayWidth = width;
        this.getEntities().values().forEach(entity -> entity.setDisplayWidth(width));
        return this.getSelf();
    }

    @Override
    public float getDisplayHeight() {
        return this.displayHeight;
    }

    @Override
    public T setDisplayHeight(float height) {
        if (height == this.displayHeight) {
            return this.getSelf();
        }
        this.displayHeight = height;
        this.getEntities().values().forEach(entity -> entity.setDisplayHeight(height));
        this.getHologram().updateHologram();
        return this.getSelf();
    }

    @Override
    public int getInterpolationDelay() {
        return this.interpolationDelay;
    }

    @Override
    public T setInterpolationDelay(int ticks) {
        if (ticks == this.interpolationDelay) {
            return this.getSelf();
        }
        this.interpolationDelay = ticks;
        this.getEntities().values().forEach(entity -> entity.setInterpolationDelay(ticks));
        return this.getSelf();
    }

    @Override
    public Display.Billboard getBillboard() {
        return this.billboard;
    }

    @Override
    public T setBillboard(Display.Billboard billboard) {
        if (Objects.equals(this.billboard, billboard)) {
            return this.getSelf();
        }
        this.billboard = billboard;
        this.getEntities().values().forEach(entity -> entity.setBillboard(billboard));
        return this.getSelf();
    }

    @Override
    protected void updateGlowColor(@Nullable TextColor color) {
        Color override = color != null ? Color.fromRGB((int)color.value()) : null;
        this.getEntities().values().forEach(entity -> entity.setGlowColorOverride(override));
    }

    @Override
    public Optional<Display.Brightness> getBrightness() {
        return Optional.ofNullable(this.brightness);
    }

    @Override
    public T setBrightness(// Could not load outer class - annotation placement on inner may be incorrect
    @Nullable Display.Brightness brightness) {
        if (Objects.equals(this.brightness, brightness)) {
            return this.getSelf();
        }
        this.brightness = brightness;
        this.getEntities().values().forEach(entity -> entity.setBrightness(brightness));
        return this.getSelf();
    }

    private T getSelf() {
        return (T)this;
    }

    @Override
    protected void preSpawn(E entity, Player player) {
        Color glowColor = this.getGlowColor().map(TextColor::value).map(Color::fromRGB).orElse(null);
        entity.setBillboard(this.billboard);
        entity.setBrightness(this.brightness);
        entity.setDisplayHeight(this.displayHeight);
        entity.setDisplayWidth(this.displayWidth);
        entity.setGlowColorOverride(glowColor);
        entity.setInterpolationDelay(this.interpolationDelay);
        entity.setInterpolationDuration(this.interpolationDuration);
        entity.setShadowRadius(this.shadowRadius);
        entity.setShadowStrength(this.shadowStrength);
        entity.setTeleportDuration(this.teleportDuration);
        entity.setTransformation(this.transformation);
        entity.setViewRange(this.viewRange);
        super.preSpawn(entity, player);
    }
}

