/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.hologram.image;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.Duration;
import java.time.Instant;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.imageio.ImageIO;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.Context;
import net.kyori.adventure.text.minimessage.ParsingException;
import net.kyori.adventure.text.minimessage.tag.Tag;
import net.kyori.adventure.text.minimessage.tag.resolver.ArgumentQueue;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.thenextlvl.hologram.image.ImageMessage;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class ImageTagResolver
implements TagResolver {
    public static final int DEFAULT_HEIGHT = 8;
    public static final Duration CACHE_TTL = Duration.ofMinutes(30L);
    public static final ImageTagResolver INSTANCE = new ImageTagResolver();
    private final Map<String, CacheEntry> cache = new ConcurrentHashMap<String, CacheEntry>();

    private ImageTagResolver() {
    }

    public Tag resolve(String name, ArgumentQueue arguments, Context ctx) throws ParsingException {
        int height;
        if (!arguments.hasNext()) {
            throw ctx.newException("The image tag requires a source argument");
        }
        String source = arguments.pop().value();
        String cacheKey = source + ":" + (height = arguments.hasNext() ? this.parseHeight(arguments.pop().value(), ctx) : 8);
        CacheEntry cached = this.cache.get(cacheKey);
        if (cached != null && !cached.isExpired()) {
            return Tag.inserting((Component)ImageMessage.read(cached.image(), height));
        }
        try {
            BufferedImage image = this.resolveImage(source, height);
            this.cache.put(cacheKey, new CacheEntry(image, Instant.now().plus(CACHE_TTL)));
            return Tag.inserting((Component)ImageMessage.read(image, height));
        }
        catch (IOException e) {
            throw ctx.newException("Failed to load image: " + e.getMessage());
        }
    }

    public boolean has(String name) {
        return "image".equals(name);
    }

    private BufferedImage resolveImage(String source, int height) throws IOException {
        if (source.startsWith("http://") || source.startsWith("https://")) {
            BufferedImage image = ImageIO.read(URI.create(source).toURL());
            if (image == null) {
                throw new IOException("Could not read image from URL: " + source);
            }
            return image;
        }
        return ImageIO.read(Files.newInputStream(Path.of(source, new String[0]), new OpenOption[0]));
    }

    private int parseHeight(String value, Context ctx) throws ParsingException {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw ctx.newException("Invalid height value: " + value);
        }
    }

    private record CacheEntry(BufferedImage image, Instant expiry) {
        boolean isExpired() {
            return Instant.now().isAfter(this.expiry);
        }
    }
}

