/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.hologram.image;

import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.JoinConfiguration;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Color;

public final class ImageMessage {
    public static final String BLOCK = "\u2588";
    public static final String DARK_SHADE = "\u2593";
    public static final String MEDIUM_SHADE = "\u2592";
    public static final String LIGHT_SHADE = "\u2591";

    public static Component read(BufferedImage image, int height) {
        return ImageMessage.toComponent(image, height);
    }

    private static Component toComponent(BufferedImage image, int height) {
        Color[][] colors = ImageMessage.toColorMatrix(image, height);
        Component[] lines = new Component[colors[0].length];
        for (int y = 0; y < colors[0].length; ++y) {
            TextComponent.Builder line = Component.text();
            for (Color[] colorData : colors) {
                Color data = colorData[y];
                String character = ImageMessage.getCharByAlpha(data.getAlpha());
                line.append((Component)Component.text((String)character, (TextColor)TextColor.color((int)data.asRGB())));
            }
            lines[y] = line.build();
        }
        return Component.join((JoinConfiguration)JoinConfiguration.newlines(), (ComponentLike[])lines);
    }

    private static Color[][] toColorMatrix(BufferedImage image, int height) {
        double ratio = (double)image.getHeight() / (double)image.getWidth();
        BufferedImage resized = ImageMessage.resizeImage(image, (int)((double)height / ratio), height);
        Color[][] matrix = new Color[resized.getWidth()][resized.getHeight()];
        for (int x = 0; x < resized.getWidth(); ++x) {
            for (int y = 0; y < resized.getHeight(); ++y) {
                matrix[x][y] = Color.fromARGB((int)resized.getRGB(x, y));
            }
        }
        return matrix;
    }

    private static String getCharByAlpha(int alpha) {
        if (alpha == 0) {
            return "  ";
        }
        return switch (alpha * 4 / 256) {
            case 0 -> LIGHT_SHADE;
            case 1 -> MEDIUM_SHADE;
            case 2 -> DARK_SHADE;
            default -> BLOCK;
        };
    }

    private static BufferedImage resizeImage(BufferedImage originalImage, int width, int height) {
        AffineTransform transform = new AffineTransform();
        double sx = (double)width / (double)originalImage.getWidth();
        double sy = (double)height / (double)originalImage.getHeight();
        transform.scale(sx, sy);
        AffineTransformOp operation = new AffineTransformOp(transform, 1);
        return operation.filter(originalImage, null);
    }
}

