/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.hologram.image;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import net.kyori.adventure.text.Component;
import net.thenextlvl.hologram.image.ImageMessage;

public final class AnimatedMessage {
    private final Component[] images;
    private int index = 0;

    private AnimatedMessage(Component ... images) {
        this.images = images;
    }

    public static AnimatedMessage readGif(File gifFile, int height) throws IOException {
        List<BufferedImage> frames = AnimatedMessage.getFrames(gifFile);
        Component[] images = new Component[frames.size()];
        for (int i = 0; i < frames.size(); ++i) {
            images[i] = ImageMessage.read(frames.get(i), height);
        }
        return new AnimatedMessage(images);
    }

    private static List<BufferedImage> getFrames(File input) throws IOException {
        ArrayList<BufferedImage> images = new ArrayList<BufferedImage>();
        ImageReader reader = ImageIO.getImageReadersBySuffix("GIF").next();
        ImageInputStream in = ImageIO.createImageInputStream(input);
        reader.setInput(in);
        int count = reader.getNumImages(true);
        for (int i = 0; i < count; ++i) {
            BufferedImage image = reader.read(i);
            images.add(image);
        }
        return images;
    }

    public Component current() {
        return this.images[this.index];
    }

    public Component next() {
        if (++this.index >= this.images.length) {
            this.index = 0;
        }
        return this.images[this.index];
    }

    public Component previous() {
        if (--this.index <= 0) {
            this.index = this.images.length - 1;
        }
        return this.images[this.index];
    }

    public Component getIndex(int index) {
        return this.images[index];
    }
}

