/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.hologram.commands.line.edit;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import io.papermc.paper.command.brigadier.argument.ArgumentTypes;
import io.papermc.paper.registry.RegistryKey;
import java.util.Optional;
import java.util.function.BiPredicate;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.minimessage.tag.resolver.Formatter;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.thenextlvl.hologram.Hologram;
import net.thenextlvl.hologram.HologramPlugin;
import net.thenextlvl.hologram.commands.brigadier.BrigadierCommand;
import net.thenextlvl.hologram.line.BlockHologramLine;
import net.thenextlvl.hologram.line.EntityHologramLine;
import net.thenextlvl.hologram.line.HologramLine;
import net.thenextlvl.hologram.line.ItemHologramLine;
import net.thenextlvl.hologram.line.TextHologramLine;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.ItemStack;
import org.jspecify.annotations.NullMarked;

@NullMarked
final class HologramLineEditSetCommand
extends BrigadierCommand {
    private HologramLineEditSetCommand(HologramPlugin plugin) {
        super(plugin, "set", "holograms.command.line.edit.set");
    }

    public static LiteralArgumentBuilder<CommandSourceStack> create(HologramPlugin plugin) {
        HologramLineEditSetCommand command = new HologramLineEditSetCommand(plugin);
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)command.create().then(command.setLine("block", ArgumentTypes.blockState(), (Command<CommandSourceStack>)((Command)command::setBlockLine)))).then(command.setLine("entity", ArgumentTypes.resource((RegistryKey)RegistryKey.ENTITY_TYPE), (Command<CommandSourceStack>)((Command)command::setEntityLine)))).then(command.setLine("item", ArgumentTypes.itemStack(), (Command<CommandSourceStack>)((Command)command::setItemLine)))).then(command.setLine("text", (ArgumentType<?>)StringArgumentType.greedyString(), (Command<CommandSourceStack>)((Command)command::setTextLine)));
    }

    private LiteralArgumentBuilder<CommandSourceStack> setLine(String name, ArgumentType<?> argumentType, Command<CommandSourceStack> command) {
        return (LiteralArgumentBuilder)Commands.literal((String)name).then(Commands.argument((String)name, argumentType).executes(command));
    }

    private int setBlockLine(CommandContext<CommandSourceStack> context) {
        BlockData block = ((BlockState)context.getArgument("block", BlockState.class)).getBlockData();
        return this.setLine(context, (hologram, line) -> {
            BlockHologramLine blockLine = hologram.getLine((int)line, BlockHologramLine.class).orElseGet(() -> hologram.setBlockLine((int)line));
            if (block.equals((Object)blockLine.getBlock())) {
                return false;
            }
            blockLine.setBlock(block);
            return true;
        });
    }

    private int setEntityLine(CommandContext<CommandSourceStack> context) {
        EntityType entity = (EntityType)context.getArgument("entity", EntityType.class);
        return this.setLine(context, (hologram, line) -> {
            if (entity.equals(hologram.getLine((int)line, EntityHologramLine.class).map(HologramLine::getEntityType).orElse(null))) {
                return false;
            }
            Optional<Double> scale = hologram.getLine((int)line, EntityHologramLine.class).map(EntityHologramLine::getScale);
            EntityHologramLine<?> entityLine = hologram.setEntityLine(entity, (int)line);
            scale.ifPresent(entityLine::setScale);
            return true;
        });
    }

    private int setItemLine(CommandContext<CommandSourceStack> context) {
        ItemStack item = (ItemStack)context.getArgument("item", ItemStack.class);
        return this.setLine(context, (hologram, line) -> {
            ItemHologramLine itemLine = hologram.getLine((int)line, ItemHologramLine.class).orElseGet(() -> hologram.setItemLine((int)line));
            if (item.equals((Object)itemLine.getItemStack())) {
                return false;
            }
            itemLine.setItemStack(item);
            return true;
        });
    }

    private int setTextLine(CommandContext<CommandSourceStack> context) {
        String text = (String)context.getArgument("text", String.class);
        return this.setLine(context, (hologram, line) -> {
            TextHologramLine textLine = hologram.getLine((int)line, TextHologramLine.class).orElseGet(() -> hologram.setTextLine((int)line));
            if (text.equals(textLine.getUnparsedText().orElse(null))) {
                return false;
            }
            textLine.setUnparsedText(text);
            return true;
        });
    }

    private <T> int setLine(CommandContext<CommandSourceStack> context, BiPredicate<Hologram, Integer> setter) {
        boolean success;
        Hologram hologram = (Hologram)context.getArgument("hologram", Hologram.class);
        Integer line = (Integer)context.getArgument("line", Integer.TYPE);
        boolean valid = line <= hologram.getLineCount();
        boolean bl = success = valid && setter.test(hologram, line - 1);
        String message = success ? "hologram.line.set" : (valid ? "nothing.changed" : "hologram.line.invalid");
        this.plugin.bundle().sendMessage((Audience)((CommandSourceStack)context.getSource()).getSender(), message, new TagResolver[]{Placeholder.unparsed((String)"hologram", (String)hologram.getName()), Formatter.number((String)"line", (Number)line)});
        return success ? 1 : 0;
    }
}

