/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.hologram.commands.line.edit;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.minimessage.tag.resolver.Formatter;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.thenextlvl.hologram.Hologram;
import net.thenextlvl.hologram.HologramPlugin;
import net.thenextlvl.hologram.commands.brigadier.SimpleCommand;
import net.thenextlvl.hologram.line.TextHologramLine;
import org.bukkit.command.CommandSender;
import org.jspecify.annotations.NullMarked;

@NullMarked
final class HologramLineEditSeeThroughCommand
extends SimpleCommand {
    private HologramLineEditSeeThroughCommand(HologramPlugin plugin) {
        super(plugin, "see-through", "holograms.command.line.edit.see-through");
    }

    public static LiteralArgumentBuilder<CommandSourceStack> create(HologramPlugin plugin) {
        HologramLineEditSeeThroughCommand command = new HologramLineEditSeeThroughCommand(plugin);
        RequiredArgumentBuilder seeThrough = Commands.argument((String)"see-through", (ArgumentType)BoolArgumentType.bool());
        return (LiteralArgumentBuilder)command.create().then(seeThrough.executes((Command)command));
    }

    public int run(CommandContext<CommandSourceStack> context) {
        CommandSender sender = ((CommandSourceStack)context.getSource()).getSender();
        Boolean seeThrough = (Boolean)context.getArgument("see-through", Boolean.TYPE);
        Hologram hologram = (Hologram)context.getArgument("hologram", Hologram.class);
        Integer line = (Integer)context.getArgument("line", Integer.TYPE);
        String message = hologram.getLine(line - 1).map(hologramLine -> {
            if (!(hologramLine instanceof TextHologramLine)) {
                return "hologram.type.text";
            }
            TextHologramLine textLine = (TextHologramLine)hologramLine;
            if (textLine.isSeeThrough() == seeThrough.booleanValue()) {
                return "nothing.changed";
            }
            textLine.setSeeThrough(seeThrough);
            return seeThrough != false ? "hologram.line.see-through.enabled" : "hologram.line.see-through.disabled";
        }).orElse("hologram.line.invalid");
        this.plugin.bundle().sendMessage((Audience)sender, message, new TagResolver[]{Placeholder.unparsed((String)"hologram", (String)hologram.getName()), Formatter.number((String)"line", (Number)line)});
        return 1;
    }
}

