/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.hologram.commands.line.edit;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import io.papermc.paper.command.brigadier.argument.ArgumentTypes;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.minimessage.tag.resolver.Formatter;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.thenextlvl.hologram.Hologram;
import net.thenextlvl.hologram.HologramPlugin;
import net.thenextlvl.hologram.commands.brigadier.SimpleCommand;
import net.thenextlvl.hologram.line.DisplayHologramLine;
import org.jspecify.annotations.NullMarked;

@NullMarked
final class HologramLineEditInterpolationDelayCommand
extends SimpleCommand {
    private HologramLineEditInterpolationDelayCommand(HologramPlugin plugin) {
        super(plugin, "interpolation-delay", "holograms.command.line.edit.interpolation-delay");
    }

    public static LiteralArgumentBuilder<CommandSourceStack> create(HologramPlugin plugin) {
        HologramLineEditInterpolationDelayCommand command = new HologramLineEditInterpolationDelayCommand(plugin);
        RequiredArgumentBuilder named = Commands.argument((String)"delay", (ArgumentType)ArgumentTypes.time());
        return (LiteralArgumentBuilder)command.create().then(named.executes((Command)command));
    }

    public int run(CommandContext<CommandSourceStack> context) {
        Hologram hologram = (Hologram)context.getArgument("hologram", Hologram.class);
        Integer lineNumber = (Integer)context.getArgument("line", Integer.TYPE);
        Integer delay = (Integer)context.getArgument("delay", Integer.TYPE);
        String message = hologram.getLine(lineNumber - 1, DisplayHologramLine.class).map(displayLine -> {
            if (displayLine.getInterpolationDelay() == delay.intValue()) {
                return "nothing.changed";
            }
            displayLine.setInterpolationDelay(delay);
            return "hologram.interpolation-delay";
        }).orElse("hologram.type.display");
        this.plugin.bundle().sendMessage((Audience)((CommandSourceStack)context.getSource()).getSender(), message, new TagResolver[]{Placeholder.unparsed((String)"hologram", (String)hologram.getName()), Formatter.number((String)"line", (Number)lineNumber), Formatter.number((String)"delay", (Number)delay)});
        return 1;
    }
}

