/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.hologram;

import java.nio.file.Path;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.thenextlvl.binder.StaticBinder;
import net.thenextlvl.hologram.Hologram;
import net.thenextlvl.hologram.line.BlockHologramLine;
import net.thenextlvl.hologram.line.HologramLine;
import net.thenextlvl.hologram.line.ItemHologramLine;
import net.thenextlvl.hologram.line.TextHologramLine;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.BlockDisplay;
import org.bukkit.entity.Entity;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.entity.Player;
import org.bukkit.entity.TextDisplay;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;

@ApiStatus.NonExtendable
public interface HologramProvider {
    @Contract(pure=true)
    public static HologramProvider instance() {
        return StaticBinder.getInstance(HologramProvider.class.getClassLoader()).find(HologramProvider.class);
    }

    @Contract(pure=true)
    public Path getDataFolder(World var1);

    @Contract(pure=true)
    public Optional<Hologram> getHologram(Entity var1);

    @Contract(pure=true)
    public <E extends Entity> Optional<HologramLine<E>> getHologramLine(E var1);

    @Contract(pure=true)
    public Optional<BlockHologramLine> getHologramLine(BlockDisplay var1);

    @Contract(pure=true)
    public Optional<ItemHologramLine> getHologramLine(ItemDisplay var1);

    @Contract(pure=true)
    public Optional<TextHologramLine> getHologramLine(TextDisplay var1);

    @Contract(pure=true)
    public Optional<Hologram> getHologram(String var1);

    @Contract(pure=true)
    public Stream<Hologram> getHolograms();

    @Contract(pure=true)
    public Stream<Hologram> getHolograms(Chunk var1);

    @Contract(pure=true)
    public Stream<Hologram> getHolograms(Player var1);

    @Contract(pure=true)
    public Stream<Hologram> getHolograms(World var1);

    @Contract(pure=true)
    public Stream<Hologram> getHologramNearby(Location var1, double var2) throws IllegalArgumentException;

    @Contract(pure=true)
    public Stream<String> getHologramNames();

    @Contract(pure=true)
    public boolean hasHologram(String var1);

    @Contract(pure=true)
    public boolean hasHologram(Hologram var1);

    @Contract(pure=true)
    public boolean isHologramPart(Entity var1);

    @Contract(mutates="this")
    public Hologram createHologram(String var1, Location var2) throws IllegalStateException;

    @Contract(mutates="this")
    public Hologram spawnHologram(String var1, Location var2, Consumer<Hologram> var3) throws IllegalStateException;

    @Contract(mutates="this,io,param")
    public boolean deleteHologram(Hologram var1);

    public void forEachHologram(Consumer<Hologram> var1);
}

