/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.hologram.models.line;

import java.util.Objects;
import java.util.Optional;
import net.thenextlvl.hologram.line.DisplayHologramLine;
import net.thenextlvl.hologram.models.PaperHologram;
import net.thenextlvl.hologram.models.line.PaperHologramLine;
import org.bukkit.Color;
import org.bukkit.entity.Display;
import org.bukkit.util.Transformation;
import org.joml.AxisAngle4f;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public abstract class PaperDisplayHologramLine<T extends DisplayHologramLine<T, E>, E extends Display>
extends PaperHologramLine<E>
implements DisplayHologramLine<T, E> {
    protected @Nullable Color glowColorOverride = null;
    protected // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable Display.Brightness brightness = null;
    protected Display.Billboard billboard = Display.Billboard.CENTER;
    protected Transformation transformation = new Transformation(new Vector3f(), new AxisAngle4f(), new Vector3f(1.0f), new AxisAngle4f());
    protected float displayHeight = 0.0f;
    protected float displayWidth = 0.0f;
    protected float shadowRadius = 0.0f;
    protected float shadowStrength = 1.0f;
    protected float viewRange = 1.0f;
    protected int interpolationDelay = 0;
    protected int interpolationDuration = 0;
    protected int teleportDuration = 4;

    public PaperDisplayHologramLine(PaperHologram hologram, Class<E> entityClass) {
        super(hologram, entityClass);
    }

    @Override
    public Transformation getTransformation() {
        return new Transformation(this.transformation.getTranslation(), this.transformation.getLeftRotation(), this.transformation.getScale(), this.transformation.getRightRotation());
    }

    @Override
    public T setTransformation(Transformation transformation) {
        if (Objects.equals(this.transformation, transformation)) {
            return this.getSelf();
        }
        this.transformation = new Transformation(transformation.getTranslation(), transformation.getLeftRotation(), transformation.getScale(), transformation.getRightRotation());
        this.getEntity().ifPresent(entity -> entity.setTransformation(transformation));
        this.getHologram().updateHologram();
        return this.getSelf();
    }

    @Override
    public T setTransformationMatrix(Matrix4f transformationMatrix) {
        this.transformation = new Transformation(transformationMatrix.getTranslation(new Vector3f()), transformationMatrix.getRotation(new AxisAngle4f()), transformationMatrix.getScale(new Vector3f()), transformationMatrix.getRotation(new AxisAngle4f()));
        this.getEntity().ifPresent(entity -> entity.setTransformationMatrix(transformationMatrix));
        this.getHologram().updateHologram();
        return this.getSelf();
    }

    @Override
    public int getInterpolationDuration() {
        return this.interpolationDuration;
    }

    @Override
    public T setInterpolationDuration(int duration) {
        if (duration == this.interpolationDuration) {
            return this.getSelf();
        }
        this.interpolationDuration = duration;
        this.getEntity().ifPresent(entity -> entity.setInterpolationDuration(duration));
        return this.getSelf();
    }

    @Override
    public int getTeleportDuration() {
        return this.teleportDuration;
    }

    @Override
    public T setTeleportDuration(int duration) {
        if (duration == this.teleportDuration) {
            return this.getSelf();
        }
        this.teleportDuration = duration;
        this.getEntity().ifPresent(entity -> entity.setTeleportDuration(duration));
        return this.getSelf();
    }

    @Override
    public float getViewRange() {
        return this.viewRange;
    }

    @Override
    public T setViewRange(float range) {
        if (range == this.viewRange) {
            return this.getSelf();
        }
        this.viewRange = range;
        this.getEntity().ifPresent(entity -> entity.setViewRange(range));
        return this.getSelf();
    }

    @Override
    public float getShadowRadius() {
        return this.shadowRadius;
    }

    @Override
    public T setShadowRadius(float radius) {
        if (radius == this.shadowRadius) {
            return this.getSelf();
        }
        this.shadowRadius = radius;
        this.getEntity().ifPresent(entity -> entity.setShadowRadius(radius));
        return this.getSelf();
    }

    @Override
    public float getShadowStrength() {
        return this.shadowStrength;
    }

    @Override
    public T setShadowStrength(float strength) {
        if (strength == this.shadowStrength) {
            return this.getSelf();
        }
        this.shadowStrength = strength;
        this.getEntity().ifPresent(entity -> entity.setShadowStrength(strength));
        return this.getSelf();
    }

    @Override
    public float getDisplayWidth() {
        return this.displayWidth;
    }

    @Override
    public T setDisplayWidth(float width) {
        if (width == this.displayWidth) {
            return this.getSelf();
        }
        this.displayWidth = width;
        this.getEntity().ifPresent(entity -> entity.setDisplayWidth(width));
        return this.getSelf();
    }

    @Override
    public float getDisplayHeight() {
        return this.displayHeight;
    }

    @Override
    public T setDisplayHeight(float height) {
        if (height == this.displayHeight) {
            return this.getSelf();
        }
        this.displayHeight = height;
        this.getEntity().ifPresent(entity -> entity.setDisplayHeight(height));
        this.getHologram().updateHologram();
        return this.getSelf();
    }

    @Override
    public int getInterpolationDelay() {
        return this.interpolationDelay;
    }

    @Override
    public T setInterpolationDelay(int ticks) {
        if (ticks == this.interpolationDelay) {
            return this.getSelf();
        }
        this.interpolationDelay = ticks;
        this.getEntity().ifPresent(entity -> entity.setInterpolationDelay(ticks));
        return this.getSelf();
    }

    @Override
    public Display.Billboard getBillboard() {
        return this.billboard;
    }

    @Override
    public T setBillboard(Display.Billboard billboard) {
        if (Objects.equals(this.billboard, billboard)) {
            return this.getSelf();
        }
        this.billboard = billboard;
        this.getEntity().ifPresent(entity -> entity.setBillboard(billboard));
        return this.getSelf();
    }

    @Override
    public Optional<Color> getGlowColorOverride() {
        return Optional.ofNullable(this.glowColorOverride);
    }

    @Override
    public T setGlowColorOverride(@Nullable Color color) {
        if (Objects.equals(this.glowColorOverride, color)) {
            return this.getSelf();
        }
        this.glowColorOverride = color;
        this.getEntity().ifPresent(entity -> entity.setGlowColorOverride(color));
        return this.getSelf();
    }

    @Override
    public Optional<Display.Brightness> getBrightness() {
        return Optional.ofNullable(this.brightness);
    }

    @Override
    public T setBrightness(// Could not load outer class - annotation placement on inner may be incorrect
    @Nullable Display.Brightness brightness) {
        if (Objects.equals(this.brightness, brightness)) {
            return this.getSelf();
        }
        this.brightness = brightness;
        this.getEntity().ifPresent(entity -> entity.setBrightness(brightness));
        return this.getSelf();
    }

    private T getSelf() {
        return (T)this;
    }

    @Override
    protected void preSpawn(E entity) {
        entity.setTransformation(this.transformation);
        entity.setDisplayWidth(this.displayWidth);
        entity.setDisplayHeight(this.displayHeight);
        entity.setShadowRadius(this.shadowRadius);
        entity.setShadowStrength(this.shadowStrength);
        entity.setViewRange(this.viewRange);
        entity.setInterpolationDuration(this.interpolationDuration);
        entity.setInterpolationDelay(this.interpolationDelay);
        entity.setTeleportDuration(this.teleportDuration);
        entity.setBillboard(this.billboard);
        entity.setGlowColorOverride(this.glowColorOverride);
        entity.setBrightness(this.brightness);
        super.preSpawn(entity);
    }
}

