/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.hologram.models;

import com.google.common.base.Preconditions;
import io.papermc.paper.math.Position;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import net.thenextlvl.hologram.Hologram;
import net.thenextlvl.hologram.HologramPlugin;
import net.thenextlvl.hologram.line.BlockHologramLine;
import net.thenextlvl.hologram.line.EntityHologramLine;
import net.thenextlvl.hologram.line.HologramLine;
import net.thenextlvl.hologram.line.ItemHologramLine;
import net.thenextlvl.hologram.line.LineType;
import net.thenextlvl.hologram.line.TextHologramLine;
import net.thenextlvl.hologram.models.line.PaperBlockHologramLine;
import net.thenextlvl.hologram.models.line.PaperEntityHologramLine;
import net.thenextlvl.hologram.models.line.PaperHologramLine;
import net.thenextlvl.hologram.models.line.PaperItemHologramLine;
import net.thenextlvl.hologram.models.line.PaperTextHologramLine;
import net.thenextlvl.nbt.NBTOutputStream;
import net.thenextlvl.nbt.serialization.NBT;
import net.thenextlvl.nbt.serialization.ParserException;
import net.thenextlvl.nbt.serialization.TagSerializable;
import net.thenextlvl.nbt.tag.CompoundTag;
import net.thenextlvl.nbt.tag.ListTag;
import net.thenextlvl.nbt.tag.Tag;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.Unmodifiable;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class PaperHologram
implements Hologram,
TagSerializable<CompoundTag> {
    private final List<HologramLine<?>> lines = new LinkedList();
    private final Set<UUID> viewers = new HashSet<UUID>();
    private final HologramPlugin plugin;
    private String name;
    private Path dataFile;
    private Path backupFile;
    private Location location;
    private @Nullable String viewPermission;
    private boolean persistent = true;
    private boolean visibleByDefault = true;
    private boolean spawned = false;

    public PaperHologram(HologramPlugin plugin, String name, Location location) {
        Preconditions.checkArgument((location.getWorld() != null ? 1 : 0) != 0, (Object)"World cannot be null");
        this.plugin = plugin;
        this.location = location;
        this.name = name;
        Path dataFolder = plugin.hologramProvider().getDataFolder(location.getWorld());
        this.dataFile = dataFolder.resolve(name + ".dat");
        this.backupFile = dataFolder.resolve(name + ".dat_old");
    }

    public PaperHologram(HologramPlugin plugin, String name, World world) {
        this(plugin, name, new Location(world, 0.0, 0.0, 0.0));
    }

    public HologramPlugin getPlugin() {
        return this.plugin;
    }

    public Stream<? extends Entity> getEntities() {
        return this.lines.stream().map(hologramLine -> hologramLine.getEntity().orElse(null)).filter(Objects::nonNull);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean setName(String name) {
        if (Objects.equals(this.name, name)) {
            return false;
        }
        if (this.plugin.hologramProvider().hasHologram(name)) {
            return false;
        }
        if (!this.updatePaths(this.getWorld(), name)) {
            return false;
        }
        this.name = name;
        return true;
    }

    private boolean updatePaths(World world, String name) {
        Path dataFolder = this.plugin.hologramProvider().getDataFolder(world);
        Path dataFile = dataFolder.resolve(name + ".dat");
        Path backupFile = dataFolder.resolve(name + ".dat_old");
        try {
            Files.createDirectories(dataFolder, new FileAttribute[0]);
            if (Files.isRegularFile(this.getDataFile(), new LinkOption[0])) {
                Files.move(this.getDataFile(), dataFile, StandardCopyOption.REPLACE_EXISTING);
            }
            if (Files.isRegularFile(this.getBackupFile(), new LinkOption[0])) {
                Files.move(this.getBackupFile(), backupFile, StandardCopyOption.REPLACE_EXISTING);
            }
        }
        catch (IOException e) {
            this.plugin.getComponentLogger().warn("Failed to move hologram data files for: {}", (Object)this.getName(), (Object)e);
            this.plugin.getComponentLogger().warn("Please look for similar issues or report this on GitHub: {}", (Object)"https://github.com/TheNextLvl-net/holograms/issues/new?template=bug_report.yml");
            HologramPlugin.ERROR_TRACKER.trackError(e);
            return false;
        }
        this.dataFile = dataFile;
        this.backupFile = backupFile;
        return true;
    }

    @Override
    public Location getLocation() {
        return this.location.clone();
    }

    @Override
    public World getWorld() {
        return this.location.getWorld();
    }

    public boolean isInChunk(Chunk chunk) {
        int chunkX = this.location.getBlockX() >> 4;
        int chunkZ = this.location.getBlockZ() >> 4;
        return chunkX == chunk.getX() && chunkZ == chunk.getZ();
    }

    @Override
    public CompletableFuture<Boolean> teleportAsync(Location location) {
        Preconditions.checkArgument((location.getWorld() != null ? 1 : 0) != 0, (Object)"World cannot be null");
        Location previous = this.location;
        boolean success = this.setLocation(location.clone());
        if (!success) {
            return CompletableFuture.completedFuture(false);
        }
        return CompletableFuture.allOf((CompletableFuture[])this.lines.stream().map(line -> (PaperHologramLine)line).map(line -> line.teleportRelative(previous, location)).toArray(CompletableFuture[]::new)).thenApply(v -> true);
    }

    private boolean setLocation(Location location) {
        if (this.location.equals((Object)location)) {
            return false;
        }
        if (this.location.getWorld().equals((Object)location.getWorld())) {
            this.location = location;
            return true;
        }
        if (!this.updatePaths(location.getWorld(), this.name)) {
            return false;
        }
        this.location = location;
        return true;
    }

    @Override
    public Stream<HologramLine<?>> getLines() {
        return this.lines.stream();
    }

    @Override
    public int getLineCount() {
        return this.lines.size();
    }

    @Override
    public Optional<HologramLine<?>> getLine(int index) {
        if (index < 0 || index >= this.lines.size()) {
            return Optional.empty();
        }
        return Optional.of(this.lines.get(index));
    }

    @Override
    public <T extends HologramLine<?>> Optional<T> getLine(int index, Class<T> type) {
        return this.getLine(index).filter(type::isInstance).map(type::cast);
    }

    @Override
    public int getLineIndex(HologramLine<?> line) {
        return this.lines.indexOf(line);
    }

    @Override
    public boolean removeLine(HologramLine<?> line) {
        boolean removed = this.lines.remove(line);
        if (removed) {
            line.getEntity().ifPresent(Entity::remove);
        }
        this.updateHologram();
        return removed;
    }

    @Override
    public boolean removeLine(int index) {
        if (index < 0 || index >= this.lines.size()) {
            return false;
        }
        HologramLine<?> removed = this.lines.remove(index);
        removed.getEntity().ifPresent(Entity::remove);
        this.updateHologram();
        return true;
    }

    @Override
    public boolean removeLines(Collection<HologramLine<?>> lines) {
        Boolean removed = lines.stream().map(this::removeLine).reduce(false, Boolean::logicalOr);
        if (removed.booleanValue()) {
            this.updateHologram();
        }
        return removed;
    }

    @Override
    public void clearLines() {
        if (this.lines.isEmpty()) {
            return;
        }
        this.getEntities().forEach(Entity::remove);
        this.lines.clear();
        this.updateHologram();
    }

    @Override
    public boolean hasLine(HologramLine<?> line) {
        return this.lines.contains(line);
    }

    @Override
    public boolean moveLine(int line, int index) {
        if (line == index) {
            return false;
        }
        if (line < 0 || line >= this.lines.size()) {
            return false;
        }
        if (index < 0 || index >= this.lines.size()) {
            return false;
        }
        this.lines.add(index, this.lines.remove(line));
        this.updateHologram();
        return true;
    }

    @Override
    public boolean swapLines(int line1, int line2) {
        if (line1 == line2) {
            return false;
        }
        if (line1 < 0 || line1 >= this.lines.size()) {
            return false;
        }
        if (line2 < 0 || line2 >= this.lines.size()) {
            return false;
        }
        HologramLine<?> hologramLine1 = this.lines.get(line1);
        HologramLine<?> hologramLine2 = this.lines.get(line2);
        this.lines.set(line1, hologramLine2);
        this.lines.set(line2, hologramLine1);
        this.updateHologram();
        return true;
    }

    @Override
    public EntityHologramLine<?> addEntityLine(EntityType entityType) throws IllegalArgumentException {
        return this.addEntityLine(entityType, this.lines.size());
    }

    @Override
    public <T extends Entity> EntityHologramLine<T> addEntityLine(Class<T> entityType) throws IllegalArgumentException {
        return this.addEntityLine(entityType, this.lines.size());
    }

    @Override
    public EntityHologramLine<?> addEntityLine(EntityType entityType, int index) throws IllegalArgumentException {
        Preconditions.checkArgument((entityType.getEntityClass() != null ? 1 : 0) != 0, (String)"Cannot spawn entity of type %s", (Object)entityType);
        return this.addEntityLine(entityType.getEntityClass(), index);
    }

    @Override
    public <T extends Entity> EntityHologramLine<T> addEntityLine(Class<T> entityType, int index) throws IllegalArgumentException {
        PaperEntityHologramLine<T> hologramLine = new PaperEntityHologramLine<T>(this, entityType);
        this.lines.add(index, hologramLine);
        this.updateHologram();
        return hologramLine;
    }

    @Override
    public BlockHologramLine addBlockLine() {
        return this.addBlockLine(this.lines.size());
    }

    @Override
    public BlockHologramLine addBlockLine(int index) {
        PaperBlockHologramLine hologramLine = new PaperBlockHologramLine(this);
        this.lines.add(index, hologramLine);
        this.updateHologram();
        return hologramLine;
    }

    @Override
    public ItemHologramLine addItemLine() {
        return this.addItemLine(this.lines.size());
    }

    @Override
    public ItemHologramLine addItemLine(int index) {
        PaperItemHologramLine hologramLine = new PaperItemHologramLine(this);
        this.lines.add(index, hologramLine);
        this.updateHologram();
        return hologramLine;
    }

    @Override
    public TextHologramLine addTextLine() {
        return this.addTextLine(this.lines.size());
    }

    @Override
    public TextHologramLine addTextLine(int index) {
        PaperTextHologramLine hologramLine = new PaperTextHologramLine(this);
        this.lines.add(index, hologramLine);
        this.updateHologram();
        return hologramLine;
    }

    @Override
    public EntityHologramLine<?> setEntityLine(EntityType entityType, int index) throws IllegalArgumentException {
        Preconditions.checkArgument((entityType.getEntityClass() != null ? 1 : 0) != 0, (String)"Cannot spawn entity of type %s", (Object)entityType);
        return this.setEntityLine(entityType.getEntityClass(), index);
    }

    @Override
    public <T extends Entity> EntityHologramLine<T> setEntityLine(Class<T> entityType, int index) throws IllegalArgumentException {
        PaperEntityHologramLine<T> hologramLine = new PaperEntityHologramLine<T>(this, entityType);
        PaperHologramLine previous = this.lines.set(index, hologramLine);
        previous.despawn();
        this.updateHologram();
        return hologramLine;
    }

    @Override
    public BlockHologramLine setBlockLine(int index) {
        PaperBlockHologramLine hologramLine = new PaperBlockHologramLine(this);
        PaperHologramLine previous = this.lines.set(index, hologramLine);
        previous.despawn();
        this.updateHologram();
        return hologramLine;
    }

    @Override
    public ItemHologramLine setItemLine(int index) {
        PaperItemHologramLine hologramLine = new PaperItemHologramLine(this);
        PaperHologramLine previous = this.lines.set(index, hologramLine);
        previous.despawn();
        this.updateHologram();
        return hologramLine;
    }

    @Override
    public TextHologramLine setTextLine(int index) {
        PaperTextHologramLine hologramLine = new PaperTextHologramLine(this);
        PaperHologramLine previous = this.lines.set(index, hologramLine);
        previous.despawn();
        this.updateHologram();
        return hologramLine;
    }

    @Override
    public Optional<String> getViewPermission() {
        return Optional.ofNullable(this.viewPermission);
    }

    @Override
    public boolean setViewPermission(@Nullable String permission) {
        if (Objects.equals(this.viewPermission, permission)) {
            return false;
        }
        this.viewPermission = permission;
        this.lines.forEach(hologramLine -> this.plugin.getServer().getOnlinePlayers().forEach(player -> ((PaperHologramLine)hologramLine).updateVisibility((Player)player)));
        return true;
    }

    @Override
    public @Unmodifiable Set<UUID> getViewers() {
        return Set.copyOf(this.viewers);
    }

    @Override
    public boolean addViewer(UUID player) {
        if (!this.viewers.add(player)) {
            return false;
        }
        if (this.lines.isEmpty() || this.isVisibleByDefault()) {
            return true;
        }
        Player online = this.plugin.getServer().getPlayer(player);
        if (online != null) {
            this.getEntities().forEach(entity -> online.showEntity((Plugin)this.plugin, entity));
        }
        return true;
    }

    @Override
    public boolean addViewers(Collection<UUID> players) {
        return players.stream().map(this::addViewer).reduce(false, Boolean::logicalOr);
    }

    @Override
    public boolean removeViewer(UUID player) {
        if (!this.viewers.remove(player)) {
            return false;
        }
        if (this.lines.isEmpty() || this.isVisibleByDefault()) {
            return true;
        }
        Player online = this.plugin.getServer().getPlayer(player);
        if (online != null) {
            this.getEntities().forEach(entity -> online.hideEntity((Plugin)this.plugin, entity));
        }
        return true;
    }

    @Override
    public boolean removeViewers(Collection<UUID> players) {
        return players.stream().map(this::removeViewer).reduce(false, Boolean::logicalOr);
    }

    @Override
    public boolean isViewer(UUID player) {
        return this.viewers.contains(player);
    }

    @Override
    public boolean canSee(Player player) {
        if (this.lines.isEmpty() || !this.isSpawned()) {
            return false;
        }
        if (!player.getWorld().equals((Object)this.location.getWorld())) {
            return false;
        }
        if (this.viewPermission != null && !player.hasPermission(this.viewPermission)) {
            return false;
        }
        return this.isVisibleByDefault() || this.isViewer(player.getUniqueId());
    }

    @Override
    public boolean isTrackedBy(Player player) {
        return this.getEntities().anyMatch(entity -> entity.getTrackedBy().contains(player));
    }

    @Override
    public boolean isVisibleByDefault() {
        return this.visibleByDefault;
    }

    @Override
    public boolean setVisibleByDefault(boolean visible) {
        if (this.visibleByDefault == visible) {
            return false;
        }
        this.visibleByDefault = visible;
        return true;
    }

    @Override
    public boolean setPersistent(boolean persistent) {
        if (this.persistent == persistent) {
            return false;
        }
        this.persistent = persistent;
        return true;
    }

    @Override
    public boolean isPersistent() {
        return this.persistent;
    }

    @Override
    public boolean persist() {
        boolean bl;
        block14: {
            if (!this.isPersistent()) {
                return false;
            }
            Path file = this.getDataFile();
            Path backup = this.getBackupFile();
            if (Files.isRegularFile(file, new LinkOption[0])) {
                Files.move(file, backup, StandardCopyOption.REPLACE_EXISTING);
            } else {
                Files.createDirectories(file.getParent(), new FileAttribute[0]);
            }
            NBTOutputStream outputStream = NBTOutputStream.create(file);
            try {
                outputStream.writeTag(this.getName(), this.serialize());
                bl = true;
                if (outputStream == null) break block14;
            }
            catch (Throwable throwable) {
                try {
                    if (outputStream != null) {
                        try {
                            outputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    if (Files.isRegularFile(backup, new LinkOption[0])) {
                        try {
                            Files.copy(backup, file, StandardCopyOption.REPLACE_EXISTING);
                            this.plugin.getComponentLogger().warn("Recovered hologram {} from potential data loss", (Object)this.getName());
                        }
                        catch (IOException e) {
                            this.plugin.getComponentLogger().error("Failed to restore hologram {}", (Object)this.getName(), (Object)e);
                        }
                    }
                    this.plugin.getComponentLogger().error("Failed to save hologram {}", (Object)this.getName(), (Object)t);
                    this.plugin.getComponentLogger().error("Please look for similar issues or report this on GitHub: {}", (Object)"https://github.com/TheNextLvl-net/holograms/issues/new?template=bug_report.yml");
                    HologramPlugin.ERROR_TRACKER.trackError(t);
                    return false;
                }
            }
            outputStream.close();
        }
        return bl;
    }

    @Override
    public Path getDataFile() {
        return this.dataFile;
    }

    @Override
    public Path getBackupFile() {
        return this.backupFile;
    }

    @Override
    public boolean spawn() {
        if (this.isSpawned() || !this.location.isChunkLoaded()) {
            return false;
        }
        double offset = 0.0;
        for (int index = this.lines.size() - 1; index >= 0; --index) {
            HologramLine<?> line = this.lines.get(index);
            PaperHologramLine hologramLine = (PaperHologramLine)line;
            Object spawn = hologramLine.spawn(offset + hologramLine.getOffsetBefore());
            offset += 0.05 + hologramLine.getHeight() + hologramLine.getOffsetAfter();
        }
        this.spawned = true;
        return true;
    }

    @Override
    public Iterator<HologramLine<?>> iterator() {
        return this.lines.iterator();
    }

    @Override
    public boolean despawn() {
        if (!this.isSpawned()) {
            return false;
        }
        this.lines.forEach(hologramLine -> ((PaperHologramLine)hologramLine).despawn());
        this.spawned = false;
        return true;
    }

    public void updateHologram() {
        if (!this.isSpawned()) {
            return;
        }
        this.despawn();
        this.spawn();
    }

    @Override
    public boolean isSpawned() {
        return this.spawned;
    }

    public void invalidate(Entity entity) {
        this.lines.forEach(line -> ((PaperHologramLine)line).invalidate(entity));
    }

    @Override
    public CompoundTag serialize() throws ParserException {
        NBT nbt = this.plugin.serializer(this.getWorld());
        CompoundTag.Builder builder = CompoundTag.builder();
        builder.put("position", nbt.serialize(this.location));
        builder.put("rotation", CompoundTag.builder().put("yaw", Float.valueOf(this.location.getYaw())).put("pitch", Float.valueOf(this.location.getPitch())).build());
        builder.put("visibleByDefault", this.visibleByDefault);
        if (this.viewPermission != null) {
            builder.put("viewPermission", this.viewPermission);
        }
        List<Tag> lines = this.lines.stream().map(nbt::serialize).toList();
        if (!lines.isEmpty()) {
            builder.put("lines", ListTag.of(lines));
        }
        return builder.build();
    }

    @Override
    public void deserialize(CompoundTag tag) throws ParserException {
        NBT nbt = this.plugin.deserializer(this);
        tag.optional("position").map(tag1 -> nbt.deserialize((Tag)tag1, Position.class)).ifPresent(position -> {
            this.location.setX(position.x());
            this.location.setY(position.y());
            this.location.setZ(position.z());
        });
        tag.optional("rotation").map(Tag::getAsCompound).ifPresent(rotation -> {
            rotation.optional("yaw").map(Tag::getAsFloat).ifPresent(arg_0 -> ((Location)this.location).setYaw(arg_0));
            rotation.optional("pitch").map(Tag::getAsFloat).ifPresent(arg_0 -> ((Location)this.location).setPitch(arg_0));
        });
        tag.optional("viewPermission").map(Tag::getAsString).ifPresent(this::setViewPermission);
        tag.optional("visibleByDefault").map(Tag::getAsBoolean).ifPresent(this::setVisibleByDefault);
        tag.optional("lines").map(Tag::getAsList).ifPresent(lines -> lines.stream().map(line -> {
            LineType type = nbt.deserialize((Tag)line.get("lineType"), LineType.class);
            return (HologramLine)nbt.deserialize((Tag)line, (Type)((Object)(switch (type) {
                default -> throw new MatchException(null, null);
                case LineType.ENTITY -> EntityHologramLine.class;
                case LineType.BLOCK -> BlockHologramLine.class;
                case LineType.ITEM -> ItemHologramLine.class;
                case LineType.TEXT -> TextHologramLine.class;
            })));
        }).forEach(this.lines::add));
    }
}

