/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.hologram.controller;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.thenextlvl.hologram.Hologram;
import net.thenextlvl.hologram.HologramPlugin;
import net.thenextlvl.hologram.HologramProvider;
import net.thenextlvl.hologram.event.HologramCreateEvent;
import net.thenextlvl.hologram.event.HologramDeleteEvent;
import net.thenextlvl.hologram.line.BlockHologramLine;
import net.thenextlvl.hologram.line.HologramLine;
import net.thenextlvl.hologram.line.ItemHologramLine;
import net.thenextlvl.hologram.line.TextHologramLine;
import net.thenextlvl.hologram.models.PaperHologram;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.entity.BlockDisplay;
import org.bukkit.entity.Entity;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.entity.Player;
import org.bukkit.entity.TextDisplay;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class PaperHologramProvider
implements HologramProvider {
    private final HologramPlugin plugin;
    public final Set<Hologram> holograms = new HashSet<Hologram>();

    public PaperHologramProvider(HologramPlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public Path getDataFolder(World world) {
        return world.getWorldPath().resolve("holograms");
    }

    @Override
    public Optional<Hologram> getHologram(Entity entity) {
        return this.getHolograms(entity.getWorld()).filter(hologram -> hologram.getLines().anyMatch(line -> line.getEntity().filter(arg_0 -> ((Entity)entity).equals(arg_0)).isPresent())).findAny();
    }

    @Override
    public <E extends Entity> Optional<HologramLine<E>> getHologramLine(E entity) {
        return this.getHolograms(entity.getWorld()).filter(hologram -> hologram.getLines().anyMatch(line -> line.getEntity().filter(arg_0 -> ((Entity)entity).equals(arg_0)).isPresent())).map(hologram -> (HologramLine)((Object)hologram)).findFirst();
    }

    @Override
    public Optional<BlockHologramLine> getHologramLine(BlockDisplay display) {
        return this.getHologramLine((Entity)display).map(BlockHologramLine.class::cast);
    }

    @Override
    public Optional<ItemHologramLine> getHologramLine(ItemDisplay display) {
        return this.getHologramLine((Entity)display).map(ItemHologramLine.class::cast);
    }

    @Override
    public Optional<TextHologramLine> getHologramLine(TextDisplay display) {
        return this.getHologramLine((Entity)display).map(TextHologramLine.class::cast);
    }

    @Override
    public Optional<Hologram> getHologram(String name) {
        return this.getHolograms().filter(hologram -> hologram.getName().equals(name)).findAny();
    }

    @Override
    public Optional<HologramLine<?>> getHologramLine(UUID uuid) {
        return this.getHolograms().flatMap(hologram -> hologram.getLines().filter(line -> line.getEntity().map(Entity::getUniqueId).filter(uuid::equals).isPresent())).findAny();
    }

    @Override
    public Stream<Hologram> getHolograms() {
        return this.holograms.stream();
    }

    @Override
    public Stream<Hologram> getHolograms(Chunk chunk) {
        return this.getHolograms(chunk.getWorld()).filter(hologram -> ((PaperHologram)hologram).isInChunk(chunk));
    }

    @Override
    public Stream<Hologram> getHolograms(Player player) {
        return this.getHolograms().filter(hologram -> hologram.canSee(player));
    }

    @Override
    public Stream<Hologram> getHolograms(World world) {
        return this.getHolograms().filter(hologram -> world.equals((Object)hologram.getWorld()));
    }

    @Override
    public Stream<Hologram> getHologramNearby(Location location, double radius) {
        Preconditions.checkArgument((radius > 0.0 ? 1 : 0) != 0, (Object)"Radius must be greater than 0");
        Preconditions.checkArgument((location.getWorld() != null ? 1 : 0) != 0, (Object)"World cannot be null");
        double radiusSquared = radius * radius;
        return this.getHolograms(location.getWorld()).filter(hologram -> hologram.getLocation().distanceSquared(location) <= radiusSquared);
    }

    @Override
    public Stream<String> getHologramNames() {
        return this.getHolograms().map(Hologram::getName);
    }

    @Override
    public boolean hasHologram(String name) {
        return this.getHolograms().anyMatch(hologram -> hologram.getName().equals(name));
    }

    @Override
    public boolean hasHologram(Hologram hologram) {
        return this.holograms.contains(hologram);
    }

    @Override
    public boolean isHologramPart(Entity entity) {
        return this.getHolograms(entity.getWorld()).anyMatch(hologram -> hologram.getLines().anyMatch(line -> line.getEntity().filter(arg_0 -> ((Entity)entity).equals(arg_0)).isPresent()));
    }

    @Override
    public Hologram createHologram(String name, Location location) throws IllegalStateException {
        Preconditions.checkState((!this.hasHologram(name) ? 1 : 0) != 0, (String)"Hologram named %s already exists", (Object)name);
        PaperHologram hologram = new PaperHologram(this.plugin, name, location);
        this.holograms.add(hologram);
        new HologramCreateEvent(hologram).callEvent();
        return hologram;
    }

    @Override
    public Hologram spawnHologram(String name, Location location, Consumer<Hologram> preSpawn) throws IllegalStateException {
        Hologram hologram = this.createHologram(name, location);
        preSpawn.accept(hologram);
        hologram.spawn();
        return hologram;
    }

    @Override
    public boolean deleteHologram(Hologram hologram) {
        if (!new HologramDeleteEvent(hologram).callEvent()) {
            return false;
        }
        hologram.despawn();
        try {
            Files.deleteIfExists(hologram.getDataFile());
            Files.deleteIfExists(hologram.getBackupFile());
        }
        catch (IOException e) {
            this.plugin.getComponentLogger().warn("Failed to delete hologram data: {}", (Object)hologram.getName(), (Object)e);
            this.plugin.getComponentLogger().warn("Please look for similar issues or report this on GitHub: {}", (Object)"https://github.com/TheNextLvl-net/holograms/issues/new?template=bug_report.yml");
            HologramPlugin.ERROR_TRACKER.trackError(e);
        }
        return this.unregister(hologram);
    }

    @Override
    public void forEachHologram(Consumer<Hologram> action) {
        this.holograms.forEach(action);
    }

    public boolean unregister(Hologram hologram) {
        return this.holograms.remove(hologram);
    }

    public Server getServer() {
        return this.plugin.getServer();
    }

    public HologramPlugin getPlugin() {
        return this.plugin;
    }
}

