/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.hologram.commands.suggestions;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.MessageComponentSerializer;
import java.lang.runtime.SwitchBootstraps;
import java.util.concurrent.CompletableFuture;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.translation.Translatable;
import net.thenextlvl.hologram.Hologram;
import net.thenextlvl.hologram.line.BlockHologramLine;
import net.thenextlvl.hologram.line.EntityHologramLine;
import net.thenextlvl.hologram.line.HologramLine;
import net.thenextlvl.hologram.line.ItemHologramLine;
import net.thenextlvl.hologram.line.TextHologramLine;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class LineSuggestionProvider
implements SuggestionProvider<CommandSourceStack> {
    public static final LineSuggestionProvider INSTANCE = new LineSuggestionProvider();

    public CompletableFuture<Suggestions> getSuggestions(CommandContext<CommandSourceStack> context, SuggestionsBuilder builder) {
        Hologram hologram = (Hologram)context.getLastChild().getArgument("hologram", Hologram.class);
        for (int index = 1; index <= hologram.getLineCount(); ++index) {
            String line = String.valueOf(index);
            if (!line.contains(builder.getRemaining())) continue;
            builder.suggest(line, LineSuggestionProvider.getTooltip(hologram, index));
        }
        return builder.buildFuture();
    }

    private static Message getTooltip(Hologram hologram, int index) {
        HologramLine hologramLine = hologram.getLine(index - 1).orElse(null);
        int n = 0;
        TextComponent tooltip = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BlockHologramLine.class, EntityHologramLine.class, ItemHologramLine.class, TextHologramLine.class}, (Object)hologramLine, n)) {
            case 0 -> {
                BlockHologramLine blockLine = (BlockHologramLine)hologramLine;
                yield (TextComponent)Component.text((String)"Block: ").append((Component)Component.translatable((Translatable)blockLine.getBlock().getMaterial()));
            }
            case 1 -> {
                EntityHologramLine entityLine = (EntityHologramLine)hologramLine;
                yield (TextComponent)Component.text((String)"Entity: ").append((Component)Component.translatable((Translatable)entityLine.getEntityType()));
            }
            case 2 -> {
                ItemHologramLine itemLine = (ItemHologramLine)hologramLine;
                yield (TextComponent)Component.text((String)"Item: ").append((Component)Component.translatable((Translatable)itemLine.getItemStack().getType()));
            }
            case 3 -> {
                TextHologramLine textLine = (TextHologramLine)hologramLine;
                yield textLine.getText().map(component -> {
                    String serialize = (String)MiniMessage.miniMessage().serialize(component);
                    return MiniMessage.miniMessage().deserialize((Object)("Text: " + serialize.replace("\n", "\\n")));
                }).orElse((Component)Component.empty());
            }
            case -1 -> Component.empty();
            default -> Component.text((String)("Unknown Line " + index));
        };
        return (Message)MessageComponentSerializer.message().serialize((Component)tooltip);
    }
}

