/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.hologram.commands.line.edit;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.minimessage.tag.resolver.Formatter;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.thenextlvl.hologram.Hologram;
import net.thenextlvl.hologram.HologramPlugin;
import net.thenextlvl.hologram.commands.arguments.EnumArgumentType;
import net.thenextlvl.hologram.commands.brigadier.SimpleCommand;
import net.thenextlvl.hologram.line.ItemHologramLine;
import net.thenextlvl.i18n.ComponentBundle;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.ItemDisplay;
import org.jspecify.annotations.NullMarked;

@NullMarked
final class HologramLineEditTransformationCommand
extends SimpleCommand {
    private HologramLineEditTransformationCommand(HologramPlugin plugin) {
        super(plugin, "transformation", "holograms.command.line.edit.transformation");
    }

    public static LiteralArgumentBuilder<CommandSourceStack> create(HologramPlugin plugin) {
        HologramLineEditTransformationCommand command = new HologramLineEditTransformationCommand(plugin);
        RequiredArgumentBuilder named = Commands.argument((String)"transformation", new EnumArgumentType<ItemDisplay.ItemDisplayTransform>(ItemDisplay.ItemDisplayTransform.class));
        return (LiteralArgumentBuilder)command.create().then(named.executes((Command)command));
    }

    public int run(CommandContext<CommandSourceStack> context) {
        CommandSender sender = ((CommandSourceStack)context.getSource()).getSender();
        Hologram hologram = (Hologram)context.getArgument("hologram", Hologram.class);
        Integer lineNumber = (Integer)context.getArgument("line", Integer.TYPE);
        ItemDisplay.ItemDisplayTransform transformation = (ItemDisplay.ItemDisplayTransform)context.getArgument("transformation", ItemDisplay.ItemDisplayTransform.class);
        String message = hologram.getLine(lineNumber - 1, ItemHologramLine.class).map(itemLine -> {
            if (itemLine.getItemDisplayTransform() == transformation) {
                return "nothing.changed";
            }
            itemLine.setItemDisplayTransform(transformation);
            return "hologram.transformation";
        }).orElse("hologram.type.item");
        ComponentBundle componentBundle = this.plugin.bundle();
        Component transformationName = componentBundle.component(switch (transformation) {
            default -> throw new MatchException(null, null);
            case ItemDisplay.ItemDisplayTransform.FIRSTPERSON_LEFTHAND -> "transformation.firstperson-lefthand";
            case ItemDisplay.ItemDisplayTransform.FIRSTPERSON_RIGHTHAND -> "transformation.firstperson-righthand";
            case ItemDisplay.ItemDisplayTransform.FIXED -> "transformation.fixed";
            case ItemDisplay.ItemDisplayTransform.GROUND -> "transformation.ground";
            case ItemDisplay.ItemDisplayTransform.GUI -> "transformation.gui";
            case ItemDisplay.ItemDisplayTransform.HEAD -> "transformation.head";
            case ItemDisplay.ItemDisplayTransform.NONE -> "transformation.none";
            case ItemDisplay.ItemDisplayTransform.THIRDPERSON_LEFTHAND -> "transformation.thirdperson-lefthand";
            case ItemDisplay.ItemDisplayTransform.THIRDPERSON_RIGHTHAND -> "transformation.thirdperson-righthand";
        }, (Audience)sender);
        this.plugin.bundle().sendMessage((Audience)sender, message, new TagResolver[]{Placeholder.parsed((String)"hologram", (String)hologram.getName()), Placeholder.component((String)"transformation", (ComponentLike)transformationName), Formatter.number((String)"line", (Number)lineNumber)});
        return 1;
    }
}

