/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.hologram.commands.line.edit;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import io.papermc.paper.command.brigadier.argument.ArgumentTypes;
import io.papermc.paper.registry.RegistryKey;
import java.util.Optional;
import java.util.function.BiConsumer;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.Formatter;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.thenextlvl.hologram.Hologram;
import net.thenextlvl.hologram.HologramPlugin;
import net.thenextlvl.hologram.commands.brigadier.BrigadierCommand;
import net.thenextlvl.hologram.line.BlockHologramLine;
import net.thenextlvl.hologram.line.EntityHologramLine;
import net.thenextlvl.hologram.line.ItemHologramLine;
import net.thenextlvl.hologram.line.TextHologramLine;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.ItemStack;
import org.jspecify.annotations.NullMarked;

@NullMarked
final class HologramLineEditSetCommand
extends BrigadierCommand {
    private HologramLineEditSetCommand(HologramPlugin plugin) {
        super(plugin, "set", "holograms.command.line.edit.set");
    }

    public static LiteralArgumentBuilder<CommandSourceStack> create(HologramPlugin plugin) {
        HologramLineEditSetCommand command = new HologramLineEditSetCommand(plugin);
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)command.create().then(command.setLine("block", ArgumentTypes.blockState(), (Command<CommandSourceStack>)((Command)command::setBlockLine)))).then(command.setLine("entity", ArgumentTypes.resource((RegistryKey)RegistryKey.ENTITY_TYPE), (Command<CommandSourceStack>)((Command)command::setEntityLine)))).then(command.setLine("item", ArgumentTypes.itemStack(), (Command<CommandSourceStack>)((Command)command::setItemLine)))).then(command.setLine("text", (ArgumentType<?>)StringArgumentType.greedyString(), (Command<CommandSourceStack>)((Command)command::setTextLine)));
    }

    private LiteralArgumentBuilder<CommandSourceStack> setLine(String name, ArgumentType<?> argumentType, Command<CommandSourceStack> command) {
        return (LiteralArgumentBuilder)Commands.literal((String)name).then(Commands.argument((String)name, argumentType).executes(command));
    }

    private int setBlockLine(CommandContext<CommandSourceStack> context) {
        BlockData block = ((BlockState)context.getArgument("block", BlockState.class)).getBlockData();
        return this.setLine(context, (hologram, line) -> hologram.getLine((int)line, BlockHologramLine.class).orElseGet(() -> hologram.setBlockLine((int)line)).setBlock(block));
    }

    private int setEntityLine(CommandContext<CommandSourceStack> context) {
        EntityType entity = (EntityType)context.getArgument("entity", EntityType.class);
        return this.setLine(context, (hologram, line) -> {
            Optional<Double> scale = hologram.getLine((int)line, EntityHologramLine.class).map(EntityHologramLine::getScale);
            EntityHologramLine<?> entityLine = hologram.setEntityLine(entity, (int)line);
            scale.ifPresent(entityLine::setScale);
        });
    }

    private int setItemLine(CommandContext<CommandSourceStack> context) {
        ItemStack item = (ItemStack)context.getArgument("item", ItemStack.class);
        return this.setLine(context, (hologram, line) -> hologram.getLine((int)line, ItemHologramLine.class).orElseGet(() -> hologram.setItemLine((int)line)).setItemStack(item));
    }

    private int setTextLine(CommandContext<CommandSourceStack> context) {
        Component text = MiniMessage.miniMessage().deserialize((Object)((String)context.getArgument("text", String.class)));
        return this.setLine(context, (hologram, line) -> hologram.getLine((int)line, TextHologramLine.class).orElseGet(() -> hologram.setTextLine((int)line)).setText(text));
    }

    private int setLine(CommandContext<CommandSourceStack> context, BiConsumer<Hologram, Integer> setter) {
        boolean success;
        Hologram hologram = (Hologram)context.getArgument("hologram", Hologram.class);
        Integer line = (Integer)context.getArgument("line", Integer.TYPE);
        boolean bl = success = line <= hologram.getLineCount();
        if (success) {
            setter.accept(hologram, line - 1);
        }
        String message = success ? "hologram.line.set" : "hologram.line.invalid";
        this.plugin.bundle().sendMessage((Audience)((CommandSourceStack)context.getSource()).getSender(), message, new TagResolver[]{Placeholder.parsed((String)"hologram", (String)hologram.getName()), Formatter.number((String)"line", (Number)line)});
        return success ? 1 : 0;
    }
}

