/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.hologram.commands.line.edit;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.minimessage.tag.resolver.Formatter;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.thenextlvl.hologram.Hologram;
import net.thenextlvl.hologram.HologramPlugin;
import net.thenextlvl.hologram.commands.brigadier.SimpleCommand;
import net.thenextlvl.hologram.line.DisplayHologramLine;
import net.thenextlvl.hologram.line.EntityHologramLine;
import org.bukkit.util.Transformation;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.jspecify.annotations.NullMarked;

@NullMarked
final class HologramLineEditScaleCommand
extends SimpleCommand {
    private HologramLineEditScaleCommand(HologramPlugin plugin) {
        super(plugin, "scale", "holograms.command.line.edit.scale");
    }

    public static LiteralArgumentBuilder<CommandSourceStack> create(HologramPlugin plugin) {
        HologramLineEditScaleCommand command = new HologramLineEditScaleCommand(plugin);
        RequiredArgumentBuilder x = Commands.argument((String)"x", (ArgumentType)FloatArgumentType.floatArg((float)0.1f));
        RequiredArgumentBuilder y = Commands.argument((String)"y", (ArgumentType)FloatArgumentType.floatArg((float)0.1f));
        RequiredArgumentBuilder z = Commands.argument((String)"z", (ArgumentType)FloatArgumentType.floatArg((float)0.1f));
        RequiredArgumentBuilder scale = Commands.argument((String)"scale", (ArgumentType)FloatArgumentType.floatArg((float)0.1f));
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)command.create().then(scale.executes((Command)command))).then(x.then(y.then(z.executes((Command)command))));
    }

    public int run(CommandContext<CommandSourceStack> context) {
        Hologram hologram = (Hologram)context.getArgument("hologram", Hologram.class);
        Integer lineNumber = (Integer)context.getArgument("line", Integer.TYPE);
        Vector3f scale = this.tryGetArgument(context, "scale", Float.TYPE).map(Vector3f::new).orElseGet(() -> {
            Float x = (Float)context.getArgument("x", Float.TYPE);
            Float y = (Float)context.getArgument("y", Float.TYPE);
            Float z = (Float)context.getArgument("z", Float.TYPE);
            return new Vector3f(x.floatValue(), y.floatValue(), z.floatValue());
        });
        String message = hologram.getLine(lineNumber - 1).map(line -> {
            if (line instanceof DisplayHologramLine) {
                DisplayHologramLine displayLine = (DisplayHologramLine)line;
                Transformation transformation = displayLine.getTransformation();
                if (transformation.getScale().equals((Object)scale)) {
                    return "nothing.changed";
                }
                transformation.getScale().set((Vector3fc)scale);
                displayLine.setTransformation(transformation);
            } else if (line instanceof EntityHologramLine) {
                EntityHologramLine entityLine = (EntityHologramLine)line;
                if (entityLine.getScale() == (double)scale.y()) {
                    return "nothing.changed";
                }
                entityLine.setScale(scale.y());
            } else {
                return "hologram.type.display";
            }
            return "hologram.scale";
        }).orElse("hologram.line.invalid");
        this.plugin.bundle().sendMessage((Audience)((CommandSourceStack)context.getSource()).getSender(), message, new TagResolver[]{Placeholder.parsed((String)"hologram", (String)hologram.getName()), Formatter.number((String)"line", (Number)lineNumber)});
        return 1;
    }
}

