/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.hologram.commands.line.edit;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import io.papermc.paper.command.brigadier.argument.ArgumentTypes;
import java.util.Objects;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.minimessage.tag.resolver.Formatter;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.thenextlvl.hologram.Hologram;
import net.thenextlvl.hologram.HologramPlugin;
import net.thenextlvl.hologram.commands.brigadier.SimpleCommand;
import net.thenextlvl.hologram.line.TextHologramLine;
import org.jspecify.annotations.NullMarked;

@NullMarked
final class HologramLineEditColorCommand
extends SimpleCommand {
    private HologramLineEditColorCommand(HologramPlugin plugin) {
        super(plugin, "color", "holograms.command.line.edit.color");
    }

    public static LiteralArgumentBuilder<CommandSourceStack> create(HologramPlugin plugin) {
        HologramLineEditColorCommand command = new HologramLineEditColorCommand(plugin);
        RequiredArgumentBuilder named = Commands.argument((String)"color", (ArgumentType)ArgumentTypes.namedColor());
        RequiredArgumentBuilder hex = Commands.argument((String)"hex", (ArgumentType)ArgumentTypes.hexColor()).suggests((context, builder) -> builder.buildFuture());
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)command.create().then(named.executes((Command)command))).then(hex.executes((Command)command))).then(Commands.literal((String)"reset").executes((Command)command));
    }

    public int run(CommandContext<CommandSourceStack> context) {
        Hologram hologram = (Hologram)context.getArgument("hologram", Hologram.class);
        Integer line = (Integer)context.getArgument("line", Integer.TYPE);
        TextColor color = this.tryGetArgument(context, "hex", TextColor.class).or(() -> this.tryGetArgument(context, "color", NamedTextColor.class)).orElse(null);
        String message = hologram.getLine(line - 1, TextHologramLine.class).map(textLine -> {
            if (Objects.equals(textLine.getText().map(Component::color).orElse(null), color)) {
                return "nothing.changed";
            }
            textLine.getText().map(component -> component.color(color)).ifPresent(textLine::setText);
            return color != null ? "hologram.text.color" : "hologram.text.color.reset";
        }).orElse("hologram.type.text");
        this.plugin.bundle().sendMessage((Audience)((CommandSourceStack)context.getSource()).getSender(), message, new TagResolver[]{Placeholder.parsed((String)"hologram", (String)hologram.getName()), Formatter.number((String)"line", (Number)line)});
        return 1;
    }
}

