/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.hologram.commands.line.edit;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.minimessage.tag.resolver.Formatter;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.thenextlvl.hologram.Hologram;
import net.thenextlvl.hologram.HologramPlugin;
import net.thenextlvl.hologram.commands.brigadier.SimpleCommand;
import net.thenextlvl.hologram.line.DisplayHologramLine;
import org.bukkit.entity.Display;
import org.jspecify.annotations.NullMarked;

@NullMarked
final class HologramLineEditBrightnessCommand
extends SimpleCommand {
    private HologramLineEditBrightnessCommand(HologramPlugin plugin) {
        super(plugin, "brightness", "holograms.command.line.edit.brightness");
    }

    public static LiteralArgumentBuilder<CommandSourceStack> create(HologramPlugin plugin) {
        HologramLineEditBrightnessCommand command = new HologramLineEditBrightnessCommand(plugin);
        IntegerArgumentType argument = IntegerArgumentType.integer((int)0, (int)15);
        RequiredArgumentBuilder brightness = Commands.argument((String)"brightness", (ArgumentType)argument);
        RequiredArgumentBuilder blockLight = Commands.argument((String)"block light", (ArgumentType)argument);
        RequiredArgumentBuilder skyLight = Commands.argument((String)"sky light", (ArgumentType)argument);
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)command.create().then(brightness.executes((Command)command))).then(blockLight.then(skyLight.executes((Command)command)))).then(Commands.literal((String)"reset").executes((Command)command));
    }

    public int run(CommandContext<CommandSourceStack> context) {
        Hologram hologram = (Hologram)context.getArgument("hologram", Hologram.class);
        Integer line = (Integer)context.getArgument("line", Integer.TYPE);
        Display.Brightness brightness = this.tryGetArgument(context, "brightness", Integer.TYPE).map(b -> new Display.Brightness(b.intValue(), b.intValue())).or(() -> this.tryGetArgument(context, "block light", Integer.TYPE).map(blockLight -> {
            Integer skyLight = (Integer)context.getArgument("sky light", Integer.TYPE);
            return new Display.Brightness(blockLight.intValue(), skyLight.intValue());
        })).orElse(null);
        String message = hologram.getLine(line - 1, DisplayHologramLine.class).map(displayLine -> {
            if (displayLine.getBrightness().orElse(null) == brightness) {
                return "nothing.changed";
            }
            displayLine.setBrightness(brightness);
            return brightness != null ? "hologram.brightness" : "hologram.brightness.reset";
        }).orElse("hologram.type.display");
        this.plugin.bundle().sendMessage((Audience)((CommandSourceStack)context.getSource()).getSender(), message, new TagResolver[]{Placeholder.parsed((String)"hologram", (String)hologram.getName()), Formatter.number((String)"line", (Number)line)});
        return 1;
    }
}

