/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.hologram.commands.line.edit;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.minimessage.tag.resolver.Formatter;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.thenextlvl.hologram.Hologram;
import net.thenextlvl.hologram.HologramPlugin;
import net.thenextlvl.hologram.commands.arguments.EnumArgumentType;
import net.thenextlvl.hologram.commands.brigadier.SimpleCommand;
import net.thenextlvl.hologram.line.TextHologramLine;
import net.thenextlvl.i18n.ComponentBundle;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.TextDisplay;
import org.jspecify.annotations.NullMarked;

@NullMarked
final class HologramLineEditAlignmentCommand
extends SimpleCommand {
    private HologramLineEditAlignmentCommand(HologramPlugin plugin) {
        super(plugin, "alignment", "holograms.command.line.edit.alignment");
    }

    public static LiteralArgumentBuilder<CommandSourceStack> create(HologramPlugin plugin) {
        HologramLineEditAlignmentCommand command = new HologramLineEditAlignmentCommand(plugin);
        RequiredArgumentBuilder named = Commands.argument((String)"alignment", new EnumArgumentType<TextDisplay.TextAlignment>(TextDisplay.TextAlignment.class));
        return (LiteralArgumentBuilder)command.create().then(named.executes((Command)command));
    }

    public int run(CommandContext<CommandSourceStack> context) {
        CommandSender sender = ((CommandSourceStack)context.getSource()).getSender();
        TextDisplay.TextAlignment alignment = (TextDisplay.TextAlignment)context.getArgument("alignment", TextDisplay.TextAlignment.class);
        Hologram hologram = (Hologram)context.getArgument("hologram", Hologram.class);
        Integer line = (Integer)context.getArgument("line", Integer.TYPE);
        String message = hologram.getLine(line - 1, TextHologramLine.class).map(textLine -> {
            if (textLine.getAlignment() == alignment) {
                return "nothing.changed";
            }
            textLine.setAlignment(alignment);
            return "hologram.text-alignment";
        }).orElse("hologram.type.text");
        ComponentBundle componentBundle = this.plugin.bundle();
        Component alignmentName = componentBundle.component(switch (alignment) {
            default -> throw new MatchException(null, null);
            case TextDisplay.TextAlignment.LEFT -> "text-alignment.left";
            case TextDisplay.TextAlignment.CENTER -> "text-alignment.center";
            case TextDisplay.TextAlignment.RIGHT -> "text-alignment.right";
        }, (Audience)sender);
        this.plugin.bundle().sendMessage((Audience)sender, message, new TagResolver[]{Placeholder.parsed((String)"hologram", (String)hologram.getName()), Placeholder.component((String)"alignment", (ComponentLike)alignmentName), Formatter.number((String)"line", (Number)line)});
        return 1;
    }
}

