/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.hologram.commands.line;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import io.papermc.paper.command.brigadier.argument.ArgumentTypes;
import io.papermc.paper.registry.RegistryKey;
import java.util.function.BiConsumer;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.Formatter;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.thenextlvl.hologram.Hologram;
import net.thenextlvl.hologram.HologramPlugin;
import net.thenextlvl.hologram.commands.HologramCommand;
import net.thenextlvl.hologram.commands.brigadier.BrigadierCommand;
import net.thenextlvl.hologram.commands.suggestions.LineSuggestionProvider;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.ItemStack;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class HologramLineInsertCommand
extends BrigadierCommand {
    private HologramLineInsertCommand(HologramPlugin plugin) {
        super(plugin, "insert", "holograms.command.line.insert");
    }

    public static LiteralArgumentBuilder<CommandSourceStack> create(HologramPlugin plugin) {
        HologramLineInsertCommand command = new HologramLineInsertCommand(plugin);
        RequiredArgumentBuilder line = Commands.argument((String)"line", (ArgumentType)IntegerArgumentType.integer((int)1)).suggests((SuggestionProvider)LineSuggestionProvider.INSTANCE);
        return (LiteralArgumentBuilder)command.create().then(HologramCommand.hologramArgument(plugin).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)line.then(command.createLine("block", ArgumentTypes.blockState(), (Command<CommandSourceStack>)((Command)command::insertBlockLine)))).then(command.createLine("entity", ArgumentTypes.resource((RegistryKey)RegistryKey.ENTITY_TYPE), (Command<CommandSourceStack>)((Command)command::insertEntityLine)))).then(command.createLine("item", ArgumentTypes.itemStack(), (Command<CommandSourceStack>)((Command)command::insertItemLine)))).then(command.createLine("text", (ArgumentType<?>)StringArgumentType.greedyString(), (Command<CommandSourceStack>)((Command)command::insertTextLine)))));
    }

    private LiteralArgumentBuilder<CommandSourceStack> createLine(String name, ArgumentType<?> argumentType, Command<CommandSourceStack> command) {
        return (LiteralArgumentBuilder)Commands.literal((String)name).then(Commands.argument((String)name, argumentType).executes(command));
    }

    private int insertBlockLine(CommandContext<CommandSourceStack> context) {
        BlockData block = ((BlockState)context.getArgument("block", BlockState.class)).getBlockData();
        return this.insertLine(context, (hologram, line) -> hologram.addBlockLine((int)line).setBlock(block));
    }

    private int insertEntityLine(CommandContext<CommandSourceStack> context) {
        EntityType entity = (EntityType)context.getArgument("entity", EntityType.class);
        return this.insertLine(context, (hologram, line) -> hologram.addEntityLine(entity, (int)line));
    }

    private int insertItemLine(CommandContext<CommandSourceStack> context) {
        ItemStack item = (ItemStack)context.getArgument("item", ItemStack.class);
        return this.insertLine(context, (hologram, line) -> hologram.addItemLine((int)line).setItemStack(item));
    }

    private int insertTextLine(CommandContext<CommandSourceStack> context) {
        Component text = MiniMessage.miniMessage().deserialize((Object)((String)context.getArgument("text", String.class)));
        return this.insertLine(context, (hologram, line) -> hologram.addTextLine((int)line).setText(text));
    }

    private int insertLine(CommandContext<CommandSourceStack> context, BiConsumer<Hologram, Integer> consumer) {
        Hologram hologram = (Hologram)context.getArgument("hologram", Hologram.class);
        Integer line = (Integer)context.getArgument("line", Integer.TYPE);
        consumer.accept(hologram, line - 1);
        this.plugin.bundle().sendMessage((Audience)((CommandSourceStack)context.getSource()).getSender(), "hologram.line.insert", new TagResolver[]{Placeholder.parsed((String)"hologram", (String)hologram.getName()), Formatter.number((String)"line", (Number)line)});
        return 1;
    }
}

