/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.nbt.serialization.adapters;

import java.util.UUID;
import net.thenextlvl.nbt.serialization.TagAdapter;
import net.thenextlvl.nbt.serialization.TagDeserializationContext;
import net.thenextlvl.nbt.serialization.TagSerializationContext;
import net.thenextlvl.nbt.tag.CompoundTag;
import net.thenextlvl.nbt.tag.Tag;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class UUIDAdapter
implements TagAdapter<UUID> {
    public static final UUIDAdapter INSTANCE = new UUIDAdapter();

    private UUIDAdapter() {
    }

    @Override
    public UUID deserialize(Tag tag, TagDeserializationContext context) {
        CompoundTag compound = tag.getAsCompound();
        long most = compound.get("most").getAsLong();
        long least = compound.get("least").getAsLong();
        return new UUID(most, least);
    }

    @Override
    public Tag serialize(UUID uuid, TagSerializationContext context) {
        return CompoundTag.builder().put("most", (Number)uuid.getMostSignificantBits()).put("least", (Number)uuid.getLeastSignificantBits()).build();
    }
}

