/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.hologram.models.line;

import java.util.Optional;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.thenextlvl.hologram.line.LineType;
import net.thenextlvl.hologram.line.TextHologramLine;
import net.thenextlvl.hologram.models.PaperHologram;
import net.thenextlvl.hologram.models.line.PaperDisplayHologramLine;
import org.bukkit.Color;
import org.bukkit.entity.TextDisplay;
import org.jetbrains.annotations.Range;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class PaperTextHologramLine
extends PaperDisplayHologramLine<TextHologramLine, TextDisplay>
implements TextHologramLine {
    private @Nullable Color backgroundColor;
    private @Nullable Component text = null;
    private TextDisplay.TextAlignment alignment = TextDisplay.TextAlignment.CENTER;
    private boolean defaultBackground = false;
    private boolean seeThrough = false;
    private boolean shadowed = false;
    private float opacity = 0.0f;
    private int lineWidth = Integer.MAX_VALUE;

    public PaperTextHologramLine(PaperHologram hologram) {
        super(hologram, TextDisplay.class);
    }

    @Override
    public LineType getType() {
        return LineType.TEXT;
    }

    @Override
    public Optional<Component> getText() {
        return Optional.ofNullable(this.text);
    }

    @Override
    public TextHologramLine setText(@Nullable Component text) {
        this.text = text;
        this.getEntity().ifPresent(entity -> entity.text(text));
        return this;
    }

    @Override
    public int getLineWidth() {
        return this.lineWidth;
    }

    @Override
    public TextHologramLine setLineWidth(int width) {
        this.lineWidth = width;
        this.getEntity().ifPresent(entity -> entity.setLineWidth(width));
        return this;
    }

    @Override
    public Optional<Color> getBackgroundColor() {
        return Optional.ofNullable(this.backgroundColor);
    }

    @Override
    public TextHologramLine setBackgroundColor(@Nullable Color color) {
        this.backgroundColor = color;
        this.getEntity().ifPresent(entity -> entity.setBackgroundColor(color));
        return this;
    }

    @Override
    public float getTextOpacity() {
        return this.opacity;
    }

    @Override
    public TextHologramLine setTextOpacity(@Range(from=0L, to=100L) float opacity) {
        this.opacity = opacity;
        this.getEntity().ifPresent(this::updateOpacity);
        return this;
    }

    @Override
    public boolean isShadowed() {
        return this.shadowed;
    }

    @Override
    public TextHologramLine setShadowed(boolean shadow) {
        this.shadowed = shadow;
        this.getEntity().ifPresent(entity -> entity.setShadowed(shadow));
        return this;
    }

    @Override
    public boolean isSeeThrough() {
        return this.seeThrough;
    }

    @Override
    public TextHologramLine setSeeThrough(boolean seeThrough) {
        this.seeThrough = seeThrough;
        this.getEntity().ifPresent(entity -> entity.setSeeThrough(seeThrough));
        return this;
    }

    @Override
    public boolean isDefaultBackground() {
        return this.defaultBackground;
    }

    @Override
    public TextHologramLine setDefaultBackground(boolean defaultBackground) {
        this.defaultBackground = defaultBackground;
        this.getEntity().ifPresent(entity -> entity.setDefaultBackground(defaultBackground));
        return this;
    }

    @Override
    public TextDisplay.TextAlignment getAlignment() {
        return this.alignment;
    }

    @Override
    public TextHologramLine setAlignment(TextDisplay.TextAlignment alignment) {
        this.alignment = alignment;
        this.getEntity().ifPresent(entity -> entity.setAlignment(alignment));
        return this;
    }

    @Override
    public double getHeight() {
        String deserialize = this.text != null ? (String)MiniMessage.miniMessage().serialize(this.text) : null;
        int lines = deserialize != null ? deserialize.split("\n|<br>|<newline>").length : 1;
        return 0.25 * (double)this.getTransformation().getScale().y() * (double)lines;
    }

    @Override
    protected void preSpawn(TextDisplay entity) {
        entity.text(this.text);
        entity.setAlignment(this.alignment);
        entity.setSeeThrough(this.seeThrough);
        entity.setShadowed(this.shadowed);
        entity.setDefaultBackground(this.defaultBackground);
        entity.setBackgroundColor(this.backgroundColor);
        entity.setLineWidth(this.lineWidth);
        this.updateOpacity(entity);
        super.preSpawn(entity);
    }

    private void updateOpacity(TextDisplay entity) {
        entity.setTextOpacity((byte)Math.round(25.0f + (100.0f - this.opacity) * 2.3f));
    }
}

