/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.hologram.models.line;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.thenextlvl.hologram.line.HologramLine;
import net.thenextlvl.hologram.models.PaperHologram;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public abstract class PaperHologramLine<E extends Entity>
implements HologramLine<E> {
    private final PaperHologram hologram;
    private final Class<E> entityClass;
    private final EntityType entityType;
    private @Nullable E entity;

    public PaperHologramLine(PaperHologram hologram, Class<E> entityClass) {
        this.hologram = hologram;
        this.entityType = Arrays.stream(EntityType.values()).filter(type -> type.getEntityClass() != null).filter(type -> type.getEntityClass().isAssignableFrom(entityClass)).findAny().orElseThrow(() -> new IllegalArgumentException("Entity type not found for " + String.valueOf(entityClass)));
        this.entityClass = entityClass;
    }

    @Override
    public Class<E> getTypeClass() {
        return this.entityClass;
    }

    @Override
    public EntityType getEntityType() {
        return this.entityType;
    }

    @Override
    public PaperHologram getHologram() {
        return this.hologram;
    }

    @Override
    public Optional<E> getEntity() {
        return Optional.ofNullable(this.entity);
    }

    @Override
    public <T> Optional<T> getEntity(Class<T> type) {
        return this.getEntity().filter(type::isInstance).map(type::cast);
    }

    @Override
    public Location getLocation() {
        return this.hologram.getLocation();
    }

    @Override
    public World getWorld() {
        return this.hologram.getWorld();
    }

    public void despawn() {
        if (this.entity == null) {
            return;
        }
        this.entity.remove();
        this.entity = null;
    }

    public abstract double getHeight();

    public double getOffsetBefore() {
        return 0.0;
    }

    public double getOffsetAfter() {
        return 0.0;
    }

    public E spawn(double offset) throws IllegalStateException {
        Preconditions.checkState((this.entity == null || !this.entity.isValid() ? 1 : 0) != 0, (Object)"Entity is already spawned");
        Location location = this.getLocation().clone().add(0.0, offset, 0.0);
        this.entity = location.getWorld().spawn(location, this.getTypeClass(), false, this::preSpawn);
        return this.entity;
    }

    public void updateVisibility(Player player) {
        if (this.entity == null) {
            return;
        }
        if (this.canSee(player)) {
            player.showEntity((Plugin)this.hologram.getPlugin(), this.entity);
        } else {
            player.hideEntity((Plugin)this.hologram.getPlugin(), this.entity);
        }
    }

    public boolean canSee(Player player) {
        if (this.entity == null || !this.entity.isValid()) {
            return false;
        }
        if (!player.getWorld().equals((Object)this.entity.getWorld())) {
            return false;
        }
        return this.hologram.canSee(player);
    }

    public CompletableFuture<Boolean> teleportRelative(Location previous, Location location) {
        return this.getEntity().filter(Entity::isValid).map(e -> e.teleportAsync(new Location(location.getWorld(), location.getX() + e.getX() - previous.getX(), location.getY() + e.getY() - previous.getY(), location.getZ() + e.getZ() - previous.getZ()))).orElseGet(() -> CompletableFuture.completedFuture(false));
    }

    protected void preSpawn(E entity) {
        entity.setPersistent(false);
        entity.setVisibleByDefault(this.hologram.isVisibleByDefault());
    }

    public void invalidate(Entity entity) {
        if (this.entity == entity) {
            this.entity = null;
        }
    }
}

