/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.hologram.commands.line;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import io.papermc.paper.command.brigadier.argument.ArgumentTypes;
import io.papermc.paper.registry.RegistryKey;
import java.util.function.Consumer;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.thenextlvl.hologram.Hologram;
import net.thenextlvl.hologram.HologramPlugin;
import net.thenextlvl.hologram.commands.HologramCommand;
import net.thenextlvl.hologram.commands.brigadier.BrigadierCommand;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.ItemStack;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class HologramLineAddCommand
extends BrigadierCommand {
    private HologramLineAddCommand(HologramPlugin plugin) {
        super(plugin, "add", "holograms.command.line.add");
    }

    public static LiteralArgumentBuilder<CommandSourceStack> create(HologramPlugin plugin) {
        HologramLineAddCommand command = new HologramLineAddCommand(plugin);
        return (LiteralArgumentBuilder)command.create().then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)HologramCommand.hologramArgument(plugin).then(command.addLine("block", ArgumentTypes.blockState(), (Command<CommandSourceStack>)((Command)command::addBlockLine)))).then(command.addLine("entity", ArgumentTypes.resource((RegistryKey)RegistryKey.ENTITY_TYPE), (Command<CommandSourceStack>)((Command)command::addEntityLine)))).then(command.addLine("item", ArgumentTypes.itemStack(), (Command<CommandSourceStack>)((Command)command::addItemLine)))).then(command.addLine("text", (ArgumentType<?>)StringArgumentType.greedyString(), (Command<CommandSourceStack>)((Command)command::addTextLine))));
    }

    private LiteralArgumentBuilder<CommandSourceStack> addLine(String name, ArgumentType<?> argumentType, Command<CommandSourceStack> command) {
        return (LiteralArgumentBuilder)Commands.literal((String)name).then(Commands.argument((String)name, argumentType).executes(command));
    }

    private int addBlockLine(CommandContext<CommandSourceStack> context) {
        BlockData block = ((BlockState)context.getArgument("block", BlockState.class)).getBlockData();
        return this.addLine(context, hologram -> hologram.addBlockLine().setBlock(block));
    }

    private int addEntityLine(CommandContext<CommandSourceStack> context) {
        EntityType entity = (EntityType)context.getArgument("entity", EntityType.class);
        return this.addLine(context, hologram -> hologram.addEntityLine(entity));
    }

    private int addItemLine(CommandContext<CommandSourceStack> context) {
        ItemStack item = (ItemStack)context.getArgument("item", ItemStack.class);
        return this.addLine(context, hologram -> hologram.addItemLine().setItemStack(item));
    }

    private int addTextLine(CommandContext<CommandSourceStack> context) {
        Component text = MiniMessage.miniMessage().deserialize((Object)((String)context.getArgument("text", String.class)));
        return this.addLine(context, hologram -> hologram.addTextLine().setText(text));
    }

    private int addLine(CommandContext<CommandSourceStack> context, Consumer<Hologram> consumer) {
        Hologram hologram = (Hologram)context.getArgument("hologram", Hologram.class);
        consumer.accept(hologram);
        return 1;
    }
}

