/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.hologram.commands;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.thenextlvl.hologram.Hologram;
import net.thenextlvl.hologram.HologramPlugin;
import net.thenextlvl.hologram.commands.HologramCommand;
import net.thenextlvl.hologram.commands.brigadier.SimpleCommand;
import org.bukkit.command.CommandSender;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class HologramRenameCommand
extends SimpleCommand {
    private HologramRenameCommand(HologramPlugin plugin) {
        super(plugin, "rename", "holograms.command.rename");
    }

    public static LiteralArgumentBuilder<CommandSourceStack> create(HologramPlugin plugin) {
        HologramRenameCommand command = new HologramRenameCommand(plugin);
        return (LiteralArgumentBuilder)command.create().then(HologramCommand.hologramArgument(plugin).then(HologramCommand.nameArgument().executes((Command)command)));
    }

    public int run(CommandContext<CommandSourceStack> context) {
        Hologram hologram = (Hologram)context.getArgument("hologram", Hologram.class);
        String name = (String)context.getArgument("name", String.class);
        CommandSender sender = ((CommandSourceStack)context.getSource()).getSender();
        if (this.plugin.hologramProvider().hasHologram(name)) {
            this.plugin.bundle().sendMessage((Audience)sender, "hologram.exists", new TagResolver[]{Placeholder.parsed((String)"hologram", (String)name)});
            return 0;
        }
        String oldName = hologram.getName();
        boolean success = hologram.setName(name);
        String message = success ? "hologram.renamed" : "nothing.changed";
        this.plugin.bundle().sendMessage((Audience)sender, message, new TagResolver[]{Placeholder.parsed((String)"hologram", (String)oldName), Placeholder.parsed((String)"name", (String)name)});
        return success ? 1 : 0;
    }
}

