/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.hologram;

import java.nio.file.Path;
import java.util.Collection;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.thenextlvl.binder.StaticBinder;
import net.thenextlvl.hologram.Hologram;
import net.thenextlvl.hologram.line.BlockHologramLine;
import net.thenextlvl.hologram.line.HologramLine;
import net.thenextlvl.hologram.line.ItemHologramLine;
import net.thenextlvl.hologram.line.TextHologramLine;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.BlockDisplay;
import org.bukkit.entity.Entity;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.entity.Player;
import org.bukkit.entity.TextDisplay;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Unmodifiable;

@ApiStatus.NonExtendable
public interface HologramProvider {
    public static HologramProvider instance() {
        return StaticBinder.getInstance(HologramProvider.class.getClassLoader()).find(HologramProvider.class);
    }

    public Path getDataFolder(World var1);

    public Optional<Hologram> getHologram(Entity var1);

    public <E extends Entity> Optional<HologramLine<E>> getHologramLine(E var1);

    public Optional<BlockHologramLine> getHologramLine(BlockDisplay var1);

    public Optional<ItemHologramLine> getHologramLine(ItemDisplay var1);

    public Optional<TextHologramLine> getHologramLine(TextDisplay var1);

    public Optional<Hologram> getHologram(String var1);

    public Optional<HologramLine<?>> getHologramLine(UUID var1);

    public Stream<Hologram> getHolograms();

    public Stream<Hologram> getHolograms(Chunk var1);

    public Stream<Hologram> getHolograms(Player var1);

    public Stream<Hologram> getHolograms(World var1);

    public @Unmodifiable Collection<? extends Hologram> getHologramNearby(Location var1, double var2) throws IllegalArgumentException;

    public Stream<String> getHologramNames();

    public boolean hasHologram(String var1);

    public boolean hasHologram(Hologram var1);

    public boolean isHologramPart(Entity var1);

    public Hologram createHologram(String var1, Location var2) throws IllegalStateException;

    public Hologram spawnHologram(String var1, Location var2, Consumer<Hologram> var3) throws IllegalStateException;

    public boolean deleteHologram(Hologram var1);

    public void forEachHologram(Consumer<Hologram> var1);
}

