/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.hologram;

import dev.faststats.bukkit.BukkitMetrics;
import io.papermc.paper.command.brigadier.Commands;
import io.papermc.paper.math.Position;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEvents;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import net.thenextlvl.binder.StaticBinder;
import net.thenextlvl.hologram.Hologram;
import net.thenextlvl.hologram.HologramProvider;
import net.thenextlvl.hologram.adapters.BlockDataAdapter;
import net.thenextlvl.hologram.adapters.BrightnessAdapter;
import net.thenextlvl.hologram.adapters.ColorAdapter;
import net.thenextlvl.hologram.adapters.ComponentAdapter;
import net.thenextlvl.hologram.adapters.ItemStackAdapter;
import net.thenextlvl.hologram.adapters.Matrix4fAdapter;
import net.thenextlvl.hologram.adapters.PositionAdapter;
import net.thenextlvl.hologram.adapters.QuaternionfAdapter;
import net.thenextlvl.hologram.adapters.TransformationAdapter;
import net.thenextlvl.hologram.adapters.Vector3fAdapter;
import net.thenextlvl.hologram.adapters.deserializers.BlockHologramLineDeserializer;
import net.thenextlvl.hologram.adapters.deserializers.EntityHologramLineDeserializer;
import net.thenextlvl.hologram.adapters.deserializers.ItemHologramLineDeserializer;
import net.thenextlvl.hologram.adapters.deserializers.TextHologramLineDeserializer;
import net.thenextlvl.hologram.adapters.serializers.BlockHologramLineSerializer;
import net.thenextlvl.hologram.adapters.serializers.EntityHologramLineSerializer;
import net.thenextlvl.hologram.adapters.serializers.ItemHologramLineSerializer;
import net.thenextlvl.hologram.adapters.serializers.TextHologramLineSerializer;
import net.thenextlvl.hologram.bstats.bukkit.Metrics;
import net.thenextlvl.hologram.commands.HologramCommand;
import net.thenextlvl.hologram.controller.PaperHologramProvider;
import net.thenextlvl.hologram.line.BlockHologramLine;
import net.thenextlvl.hologram.line.EntityHologramLine;
import net.thenextlvl.hologram.line.ItemHologramLine;
import net.thenextlvl.hologram.line.LineType;
import net.thenextlvl.hologram.line.TextHologramLine;
import net.thenextlvl.hologram.listeners.ChunkListener;
import net.thenextlvl.hologram.listeners.EntityListener;
import net.thenextlvl.hologram.listeners.HologramListener;
import net.thenextlvl.hologram.listeners.WorldListener;
import net.thenextlvl.hologram.models.PaperHologram;
import net.thenextlvl.i18n.ComponentBundle;
import net.thenextlvl.nbt.NBTInputStream;
import net.thenextlvl.nbt.serialization.NBT;
import net.thenextlvl.nbt.serialization.adapters.EnumAdapter;
import net.thenextlvl.nbt.tag.CompoundTag;
import org.bukkit.Color;
import org.bukkit.World;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Display;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.entity.TextDisplay;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.util.Transformation;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class HologramPlugin
extends JavaPlugin {
    public static final String ISSUES = "https://github.com/TheNextLvl-net/holograms/issues/new";
    private final PaperHologramProvider provider = new PaperHologramProvider(this);
    private final Metrics metrics = new Metrics((Plugin)this, 25817);
    private final dev.faststats.core.Metrics fastStats = BukkitMetrics.factory().token("27b63937a461e94208f25b105af290cf").create((Plugin)this);
    private final Key key = Key.key((String)"holograms", (String)"translations");
    private final Path translations = this.getDataPath().resolve("translations");
    private final ComponentBundle bundle = ComponentBundle.builder(this.key, this.translations).placeholder("prefix", "prefix").resource("messages.properties", Locale.US).resource("messages_german.properties", Locale.GERMANY).build();

    public HologramPlugin() {
        StaticBinder.getInstance(HologramProvider.class.getClassLoader()).bind(HologramProvider.class, this.provider);
    }

    public void onEnable() {
        this.registerCommands();
        this.registerListeners();
    }

    private void registerCommands() {
        this.getLifecycleManager().registerEventHandler(LifecycleEvents.COMMANDS.newHandler(event -> ((Commands)event.registrar()).register(HologramCommand.create(this), "The main command to interact with holograms", Set.of("holo"))));
    }

    private void registerListeners() {
        this.getServer().getPluginManager().registerEvents((Listener)new ChunkListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new EntityListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new HologramListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new WorldListener(this), (Plugin)this);
    }

    public void onDisable() {
        this.provider.forEachHologram(Hologram::persist);
        this.metrics.shutdown();
    }

    public PaperHologramProvider hologramProvider() {
        return this.provider;
    }

    public ComponentBundle bundle() {
        return this.bundle;
    }

    private NBT.Builder base(World world) {
        return NBT.builder().registerTypeHierarchyAdapter((Class<?>)Display.Billboard.class, new EnumAdapter<Display.Billboard>(Display.Billboard.class)).registerTypeHierarchyAdapter((Class<?>)BlockData.class, new BlockDataAdapter(this.getServer())).registerTypeHierarchyAdapter((Class<?>)Display.Brightness.class, new BrightnessAdapter()).registerTypeHierarchyAdapter((Class<?>)Color.class, new ColorAdapter()).registerTypeHierarchyAdapter((Class<?>)Component.class, new ComponentAdapter()).registerTypeHierarchyAdapter((Class<?>)EntityType.class, new EnumAdapter<EntityType>(EntityType.class)).registerTypeHierarchyAdapter((Class<?>)ItemDisplay.ItemDisplayTransform.class, new EnumAdapter<ItemDisplay.ItemDisplayTransform>(ItemDisplay.ItemDisplayTransform.class)).registerTypeHierarchyAdapter((Class<?>)ItemStack.class, new ItemStackAdapter()).registerTypeHierarchyAdapter((Class<?>)LineType.class, new EnumAdapter<LineType>(LineType.class)).registerTypeHierarchyAdapter((Class<?>)Matrix4f.class, new Matrix4fAdapter()).registerTypeHierarchyAdapter((Class<?>)Position.class, new PositionAdapter()).registerTypeHierarchyAdapter((Class<?>)Quaternionf.class, new QuaternionfAdapter()).registerTypeHierarchyAdapter((Class<?>)TextDisplay.TextAlignment.class, new EnumAdapter<TextDisplay.TextAlignment>(TextDisplay.TextAlignment.class)).registerTypeHierarchyAdapter((Class<?>)Transformation.class, new TransformationAdapter()).registerTypeHierarchyAdapter((Class<?>)Vector3f.class, new Vector3fAdapter());
    }

    public NBT serializer(World world) {
        return this.base(world).registerTypeHierarchyAdapter(BlockHologramLine.class, new BlockHologramLineSerializer()).registerTypeHierarchyAdapter(EntityHologramLine.class, new EntityHologramLineSerializer()).registerTypeHierarchyAdapter(ItemHologramLine.class, new ItemHologramLineSerializer()).registerTypeHierarchyAdapter(TextHologramLine.class, new TextHologramLineSerializer()).build();
    }

    public NBT deserializer(PaperHologram hologram) {
        return this.base(hologram.getWorld()).registerTypeHierarchyAdapter(BlockHologramLine.class, new BlockHologramLineDeserializer(hologram)).registerTypeHierarchyAdapter(EntityHologramLine.class, new EntityHologramLineDeserializer(hologram)).registerTypeHierarchyAdapter(ItemHologramLine.class, new ItemHologramLineDeserializer(hologram)).registerTypeHierarchyAdapter(TextHologramLine.class, new TextHologramLineDeserializer(hologram)).build();
    }

    public void loadHolograms(World world) {
        Path dataFolder = this.hologramProvider().getDataFolder(world);
        if (!Files.isDirectory(dataFolder, new LinkOption[0])) {
            return;
        }
        try (Stream<Path> files = Files.find(dataFolder, 1, (path, attributes) -> attributes.isRegularFile() && path.getFileName().toString().endsWith(".dat"), new FileVisitOption[0]);){
            files.map(path -> this.loadSafe((Path)path, world)).filter(Objects::nonNull).forEach(Hologram::spawn);
        }
        catch (IOException e) {
            this.getComponentLogger().error("Failed to load all holograms in world {}", (Object)world.getName(), (Object)e);
        }
    }

    /*
     * Exception decompiling
     */
    public @Nullable Hologram loadSafe(Path file, World world) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK], 8[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private @Nullable Hologram load(NBTInputStream inputStream, World world) throws IOException {
        Map.Entry<String, CompoundTag> entry = inputStream.readNamedTag();
        String name = entry.getKey();
        if (this.hologramProvider().hasHologram(name)) {
            this.getComponentLogger().warn("A hologram with the name '{}' is already loaded", (Object)name);
            return null;
        }
        PaperHologram hologram = new PaperHologram(this, name, world);
        hologram.deserialize(entry.getValue());
        this.hologramProvider().holograms.add(hologram);
        return hologram;
    }
}

