/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.hologram.models.line;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.thenextlvl.hologram.HologramPlugin;
import net.thenextlvl.hologram.line.HologramLine;
import net.thenextlvl.hologram.line.PagedHologramLine;
import net.thenextlvl.hologram.line.StaticHologramLine;
import net.thenextlvl.hologram.models.PaperHologram;
import net.thenextlvl.hologram.models.line.PaperHologramLine;
import org.bukkit.Location;
import org.bukkit.entity.Display;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Interaction;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scoreboard.Team;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public abstract class PaperStaticHologramLine<E extends Entity>
extends PaperHologramLine
implements StaticHologramLine {
    protected final Map<UUID, E> entities = new ConcurrentHashMap<UUID, E>();
    protected final Map<UUID, Interaction> interactions = new ConcurrentHashMap<UUID, Interaction>();
    protected volatile @Nullable PagedHologramLine parentLine;
    protected volatile @Nullable TextColor glowColor = null;
    protected volatile Class<E> entityClass;
    protected volatile Display.Billboard billboard = Display.Billboard.CENTER;
    protected volatile EntityType entityType;
    protected volatile boolean glowing = false;

    public PaperStaticHologramLine(PaperHologram hologram, @Nullable PagedHologramLine parentLine, EntityType entityType) throws IllegalArgumentException {
        super(hologram);
        Preconditions.checkArgument((entityType.getEntityClass() != null ? 1 : 0) != 0, (String)"Entity type %s is not spawnable", (Object)entityType);
        this.entityType = entityType;
        this.entityClass = entityType.getEntityClass();
        this.parentLine = parentLine;
    }

    @Override
    public Optional<TextColor> getGlowColor() {
        return Optional.ofNullable(this.glowColor);
    }

    @Override
    public StaticHologramLine setGlowColor(@Nullable TextColor color) {
        return (StaticHologramLine)this.set(this.glowColor, color, () -> {
            this.glowColor = color;
            this.updateGlowColor(color);
        }, false);
    }

    @Override
    public boolean isGlowing() {
        return this.glowing;
    }

    @Override
    public StaticHologramLine setGlowing(boolean glowing) {
        return (StaticHologramLine)this.set(this.glowing, glowing, () -> {
            this.glowing = glowing;
            this.forEachEntity(entity -> entity.setGlowing(glowing));
        }, false);
    }

    protected abstract void updateGlowColor(@Nullable TextColor var1);

    @Override
    public Class<? extends Entity> getEntityClass() {
        return this.entityClass;
    }

    @Override
    public EntityType getEntityType() {
        return this.entityType;
    }

    @Override
    public Optional<Entity> getEntity(Player player) {
        return Optional.ofNullable((Entity)this.entities.get(player.getUniqueId()));
    }

    @Override
    public <T> Optional<T> getEntity(Player player, Class<T> type) {
        return this.getEntity(player).filter(type::isInstance).map(type::cast);
    }

    @Override
    public Optional<PagedHologramLine> getParentLine() {
        return Optional.ofNullable(this.parentLine);
    }

    @Override
    public Optional<String> getViewPermission() {
        return super.getViewPermission().or(() -> this.getParentLine().flatMap(HologramLine::getViewPermission));
    }

    @Override
    public Display.Billboard getBillboard() {
        return this.billboard;
    }

    @Override
    public CompletableFuture<Void> despawn() {
        CompletableFuture[] futures = (CompletableFuture[])Stream.concat(this.entities.values().stream(), this.interactions.values().stream()).map(e -> this.getHologram().getPlugin().supply((Entity)e, () -> ((Entity)e).remove())).toArray(CompletableFuture[]::new);
        this.entities.clear();
        this.interactions.clear();
        return CompletableFuture.allOf(futures);
    }

    @Override
    public CompletableFuture<@Nullable Void> despawn(UUID player) {
        Interaction interaction;
        ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>(2);
        Entity entity = (Entity)this.entities.remove(player);
        if (entity != null) {
            futures.add(this.getHologram().getPlugin().supply(entity, () -> ((Entity)entity).remove()));
        }
        if ((interaction = this.interactions.remove(player)) != null) {
            futures.add(this.getHologram().getPlugin().supply((Entity)interaction, () -> ((Interaction)interaction).remove()));
        }
        return CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
    }

    @Override
    public CompletableFuture<@Nullable Entity> spawn(Player player, double offset) {
        if (!this.getHologram().getWorld().equals((Object)player.getWorld()) || !this.canSee(player)) {
            return CompletableFuture.completedFuture(null);
        }
        return this.spawnEntity(player, offset).thenCompose(entity -> this.spawnInteraction(player, entity).thenCompose(interaction -> this.getHologram().getPlugin().supply((Entity)player, () -> {
            if (player.getServer().isOwnedByCurrentRegion(entity)) {
                player.showEntity((Plugin)this.getHologram().getPlugin(), entity);
            }
            if (interaction != null && player.getServer().isOwnedByCurrentRegion((Entity)interaction)) {
                player.showEntity((Plugin)this.getHologram().getPlugin(), (Entity)interaction);
            }
        }).thenApply(v -> entity)));
    }

    public CompletableFuture<E> spawnEntity(Player player, double offset) {
        Entity existing = (Entity)this.entities.get(player.getUniqueId());
        Location location = this.mutateSpawnLocation(this.getHologram().getLocation().add(0.0, offset, 0.0));
        if (existing != null) {
            return existing.teleportAsync(location).thenApply(ignored -> {
                this.preSpawn(existing, player);
                return existing;
            });
        }
        return this.getHologram().getPlugin().supply(location, () -> {
            Entity spawn = location.getWorld().spawn(location, this.entityClass, false, e -> this.preSpawn(e, player));
            this.entities.put(player.getUniqueId(), spawn);
            return spawn;
        });
    }

    public CompletableFuture<@Nullable Interaction> spawnInteraction(Player player, E entity) {
        Interaction existingInteraction = this.interactions.get(player.getUniqueId());
        Location location = entity.getLocation().subtract(0.0, this.getOffsetBefore(player), 0.0);
        if (this.hasActions() || this.getParentLine().map(HologramLine::hasActions).orElse(false).booleanValue()) {
            if (existingInteraction != null) {
                return existingInteraction.teleportAsync(location).thenApply(ignored -> {
                    this.preSpawnInteraction(existingInteraction, player, entity);
                    return existingInteraction;
                });
            }
            return this.getHologram().getPlugin().supply(location, () -> {
                Interaction interaction = (Interaction)location.getWorld().spawn(location, Interaction.class, false, e -> this.preSpawnInteraction((Interaction)e, player, entity));
                this.interactions.put(player.getUniqueId(), interaction);
                return interaction;
            });
        }
        if (existingInteraction != null) {
            return this.getHologram().getPlugin().supply((Entity)existingInteraction, () -> ((Interaction)existingInteraction).remove()).thenApply(v -> null);
        }
        return CompletableFuture.completedFuture(null);
    }

    protected Location mutateSpawnLocation(Location location) {
        return location;
    }

    protected void preSpawnInteraction(Interaction interaction, Player player, E entity) {
        interaction.setInteractionHeight((float)this.getHeight(player));
        interaction.setInteractionWidth((float)Math.max(1.0, entity.getWidth()));
        interaction.setResponsive(true);
        interaction.setPersistent(false);
        interaction.setVisibleByDefault(false);
    }

    protected void preSpawn(E entity, Player player) {
        this.updateTeamOptions(player, (Entity)entity);
        entity.setPersistent(false);
        entity.setVisibleByDefault(false);
        entity.setGlowing(this.glowing);
        this.updateGlowColor(this.glowColor);
    }

    @Override
    public CompletableFuture<Void> teleportRelative(Location previous, Location location) {
        Stream<Interaction> entities = Stream.concat(this.entities.values().stream(), this.interactions.values().stream());
        return CompletableFuture.allOf((CompletableFuture[])entities.filter(Entity::isValid).map(entity -> entity.teleportAsync(new Location(location.getWorld(), location.getX() + entity.getX() - previous.getX(), location.getY() + entity.getY() - previous.getY(), location.getZ() + entity.getZ() - previous.getZ(), location.getYaw(), location.getPitch()))).toArray(CompletableFuture[]::new));
    }

    @Override
    public boolean isPart(Entity entity) {
        Interaction interaction;
        return this.entityClass.isInstance(entity) && this.entities.containsValue(this.entityClass.cast(entity)) || entity instanceof Interaction && this.interactions.containsValue(interaction = (Interaction)entity);
    }

    @Override
    public void invalidate(Entity entity) {
        Player owner = this.remove(entity);
        if (owner == null) {
            return;
        }
        Team team = owner.getScoreboard().getTeam(entity.getScoreboardEntryName());
        if (team != null) {
            team.unregister();
        }
    }

    private @Nullable Player remove(Entity entity) {
        Iterator<Map.Entry<UUID, E>> iterator = this.entities.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<UUID, E> entry = iterator.next();
            if (!((Entity)entry.getValue()).equals((Object)entity)) continue;
            iterator.remove();
            return this.getHologram().getPlugin().getServer().getPlayer(entry.getKey());
        }
        return null;
    }

    public CompletableFuture<@Nullable Void> adoptEntities(PaperStaticHologramLine<?> oldPage, Player player) {
        return this.adoptInteraction(oldPage, player).thenCompose(ignored -> this.adoptEntity(oldPage, player));
    }

    private CompletableFuture<@Nullable Void> adoptInteraction(PaperStaticHologramLine<?> oldPage, Player player) {
        Interaction interaction = oldPage.interactions.remove(player.getUniqueId());
        if (interaction != null && !this.hasActions() && !this.getParentLine().map(HologramLine::hasActions).orElse(false).booleanValue()) {
            return this.getHologram().getPlugin().supply((Entity)interaction, () -> ((Interaction)interaction).remove());
        }
        if (interaction != null) {
            this.interactions.put(player.getUniqueId(), interaction);
        }
        return CompletableFuture.completedFuture(null);
    }

    private CompletableFuture<@Nullable Void> adoptEntity(PaperStaticHologramLine<?> oldPage, Player player) {
        Entity entity = (Entity)oldPage.entities.remove(player.getUniqueId());
        if (entity == null) {
            return CompletableFuture.completedFuture(null);
        }
        if (!this.entityClass.isInstance(entity)) {
            return this.getHologram().getPlugin().supply(entity, () -> ((Entity)entity).remove());
        }
        this.entities.put(player.getUniqueId(), entity);
        return CompletableFuture.completedFuture(null);
    }

    protected final void updateTeamOptions(Player player, Entity entity) {
        if (HologramPlugin.RUNNING_FOLIA) {
            return;
        }
        Team team = this.getSettingsTeam(player, entity);
        team.color((NamedTextColor)this.getGlowColor().map(NamedTextColor::nearestTo).orElse(null));
        team.setOption(Team.Option.COLLISION_RULE, Team.OptionStatus.NEVER);
    }

    private Team getSettingsTeam(Player player, Entity entity) {
        Team settings = player.getScoreboard().getTeam(entity.getScoreboardEntryName());
        if (settings != null) {
            return settings;
        }
        settings = player.getScoreboard().registerNewTeam(entity.getScoreboardEntryName());
        settings.addEntry(entity.getScoreboardEntryName());
        return settings;
    }

    public void forEachEntity(Consumer<E> consumer) {
        this.entities.values().forEach(consumer);
    }
}

