/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.hologram.models.line;

import com.destroystokyo.paper.profile.PlayerProfile;
import io.papermc.paper.datacomponent.DataComponentBuilder;
import io.papermc.paper.datacomponent.DataComponentTypes;
import io.papermc.paper.datacomponent.item.ResolvableProfile;
import java.util.Objects;
import net.thenextlvl.hologram.line.ItemHologramLine;
import net.thenextlvl.hologram.line.LineType;
import net.thenextlvl.hologram.models.PaperHologram;
import net.thenextlvl.hologram.models.line.PaperDisplayHologramLine;
import net.thenextlvl.hologram.models.line.PaperPagedHologramLine;
import org.bukkit.Material;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.ItemType;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public final class PaperItemHologramLine
extends PaperDisplayHologramLine<ItemDisplay>
implements ItemHologramLine {
    private volatile ItemDisplay.ItemDisplayTransform displayTransform = ItemDisplay.ItemDisplayTransform.FIXED;
    private volatile @Nullable ItemStack item = null;
    private volatile boolean playerHead = false;

    public PaperItemHologramLine(PaperHologram hologram, @Nullable PaperPagedHologramLine parent) {
        super(hologram, parent, EntityType.ITEM_DISPLAY);
    }

    @Override
    public LineType getType() {
        return LineType.ITEM;
    }

    @Override
    public ItemStack getItemStack() {
        ItemStack itemStack = this.item;
        return itemStack != null ? itemStack.clone() : ItemType.AIR.createItemStack();
    }

    @Override
    public ItemHologramLine setItemStack(@Nullable ItemStack item) {
        return (ItemHologramLine)this.set(this.item, item, () -> {
            if (item != null) {
                this.playerHead = false;
            }
            this.item = item != null ? item.clone() : null;
            this.forEachEntity(entity -> entity.setItemStack(this.item));
        }, false);
    }

    @Override
    public boolean isPlayerHead() {
        return this.playerHead;
    }

    @Override
    public ItemHologramLine setPlayerHead(boolean playerHead) {
        if (Objects.equals(this.playerHead, playerHead)) {
            return this;
        }
        this.playerHead = playerHead;
        if (playerHead) {
            this.item = ItemStack.of((Material)Material.PLAYER_HEAD);
        }
        if (playerHead) {
            this.entities.forEach((uuid, entity) -> {
                ItemStack head = ItemStack.of((Material)Material.PLAYER_HEAD);
                head.setData(DataComponentTypes.PROFILE, (DataComponentBuilder)ResolvableProfile.resolvableProfile().uuid(uuid));
                entity.setItemStack(head);
            });
        } else {
            this.forEachEntity(entity -> entity.setItemStack(this.item));
        }
        return this;
    }

    @Override
    public ItemDisplay.ItemDisplayTransform getItemDisplayTransform() {
        return this.displayTransform;
    }

    @Override
    public ItemHologramLine setItemDisplayTransform(ItemDisplay.ItemDisplayTransform display) {
        return (ItemHologramLine)this.set(this.displayTransform, display, () -> {
            this.displayTransform = display;
        }, true);
    }

    @Override
    public double getHeight(Player player) {
        if (this.isSkull(this.item)) {
            return (switch (this.displayTransform) {
                default -> throw new MatchException(null, null);
                case ItemDisplay.ItemDisplayTransform.GUI -> 0.9;
                case ItemDisplay.ItemDisplayTransform.NONE, ItemDisplay.ItemDisplayTransform.FIRSTPERSON_LEFTHAND, ItemDisplay.ItemDisplayTransform.FIRSTPERSON_RIGHTHAND, ItemDisplay.ItemDisplayTransform.FIXED, ItemDisplay.ItemDisplayTransform.HEAD -> 0.5;
                case ItemDisplay.ItemDisplayTransform.THIRDPERSON_LEFTHAND, ItemDisplay.ItemDisplayTransform.THIRDPERSON_RIGHTHAND -> 0.3;
                case ItemDisplay.ItemDisplayTransform.GROUND -> 0.2;
            }) * (double)this.transformation.getScale().y();
        }
        return (switch (this.displayTransform) {
            default -> throw new MatchException(null, null);
            case ItemDisplay.ItemDisplayTransform.GUI, ItemDisplay.ItemDisplayTransform.NONE, ItemDisplay.ItemDisplayTransform.HEAD -> 1.0;
            case ItemDisplay.ItemDisplayTransform.FIRSTPERSON_LEFTHAND, ItemDisplay.ItemDisplayTransform.FIRSTPERSON_RIGHTHAND, ItemDisplay.ItemDisplayTransform.THIRDPERSON_LEFTHAND, ItemDisplay.ItemDisplayTransform.THIRDPERSON_RIGHTHAND, ItemDisplay.ItemDisplayTransform.GROUND -> 0.45;
            case ItemDisplay.ItemDisplayTransform.FIXED -> 0.5;
        }) * (double)this.transformation.getScale().y();
    }

    @Override
    public double getOffsetBefore(Player player) {
        if (this.displayTransform == ItemDisplay.ItemDisplayTransform.GROUND) {
            return 0.0;
        }
        double v = this.getHeight(player) / 2.0;
        if (!this.isSkull(this.item)) {
            return v;
        }
        return v + (switch (this.displayTransform) {
            case ItemDisplay.ItemDisplayTransform.NONE, ItemDisplay.ItemDisplayTransform.FIRSTPERSON_LEFTHAND, ItemDisplay.ItemDisplayTransform.FIRSTPERSON_RIGHTHAND, ItemDisplay.ItemDisplayTransform.HEAD -> 0.25;
            default -> 0.0;
        });
    }

    @Override
    public double getOffsetAfter(Player player) {
        double d;
        if (this.isSkull(this.item)) {
            switch (this.displayTransform) {
                case THIRDPERSON_LEFTHAND: 
                case THIRDPERSON_RIGHTHAND: 
                case GROUND: {
                    d = 0.0;
                    break;
                }
                default: {
                    d = -this.getOffsetBefore(player);
                    break;
                }
            }
        } else {
            d = 0.0;
        }
        return d;
    }

    private boolean isSkull(@Nullable ItemStack item) {
        boolean bl;
        block4: {
            block3: {
                if (item == null) break block3;
                switch (item.getType()) {
                    case PLAYER_HEAD: 
                    case ZOMBIE_HEAD: 
                    case PISTON_HEAD: 
                    case PIGLIN_HEAD: 
                    case DRAGON_HEAD: 
                    case CREEPER_HEAD: {
                        break;
                    }
                    default: {
                        break block3;
                    }
                }
                bl = true;
                break block4;
            }
            bl = false;
        }
        return bl;
    }

    @Override
    protected void preSpawn(ItemDisplay entity, Player player) {
        ItemStack item;
        ItemStack itemStack = item = this.playerHead ? ItemStack.of((Material)Material.PLAYER_HEAD) : this.item;
        if (this.playerHead && item != null) {
            item.setData(DataComponentTypes.PROFILE, (Object)ResolvableProfile.resolvableProfile((PlayerProfile)player.getPlayerProfile()));
        }
        entity.setItemStack(item);
        entity.setItemDisplayTransform(this.displayTransform);
        super.preSpawn(entity, player);
    }
}

