/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.hologram.locale;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.renderer.TranslatableComponentRenderer;
import net.kyori.adventure.translation.Translator;
import net.thenextlvl.hologram.HologramPlugin;
import net.thenextlvl.hologram.locale.LanguageTags;
import net.thenextlvl.hologram.locale.Tips;
import net.thenextlvl.hologram.locale.store.MutableMiniMessageTranslationStore;
import org.bukkit.entity.Player;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class HologramTranslationStore
extends MutableMiniMessageTranslationStore {
    private final TranslatableComponentRenderer<Locale> renderer = TranslatableComponentRenderer.usingTranslationSource((Translator)this);
    private final HologramPlugin plugin;
    private final Path path;

    public HologramTranslationStore(HologramPlugin plugin) {
        super(Key.key((String)"holograms", (String)"translations"), MiniMessage.miniMessage());
        this.path = plugin.getTranslationsPath().resolve("custom");
        this.plugin = plugin;
        this.read();
        this.registerDefaults();
    }

    public String translate(Player player, String string, int depth) {
        if (depth > 10) {
            this.plugin.getComponentLogger().warn("Too many recursive translations for {}", (Object)string);
            return string;
        }
        Map allTranslations = this.plugin.translations().getAllTranslations(player.locale());
        String translated = string;
        for (Map.Entry entry : allTranslations.entrySet()) {
            String key = Pattern.quote(entry.getKey());
            String value = Matcher.quoteReplacement((String)entry.getValue());
            translated = translated.replaceAll("(?<!\\\\)<lang:" + key + ">", value);
            translated = translated.replaceAll("(?<!\\\\)<translate:" + key + ">", value);
            translated = translated.replaceAll("(?<!\\\\)<tr:" + key + ">", value);
        }
        if (translated.equals(string)) {
            return string;
        }
        return this.translate(player, translated, depth + 1);
    }

    public void registerDefaults() {
        int i;
        for (i = 0; i < Tips.TIPS_ENGLISH.size(); ++i) {
            this.registerIfMissing("hologram.tip." + (i + 1), Locale.US, Tips.TIPS_ENGLISH.get(i));
        }
        for (i = 0; i < Tips.TIPS_GERMAN.size(); ++i) {
            this.registerIfMissing("hologram.tip." + (i + 1), Locale.GERMANY, Tips.TIPS_GERMAN.get(i));
        }
        this.registerIfMissing("hologram.tip.page", Locale.US, "<italic><gray>Tip <page>/<pages></gray></italic>");
        this.registerIfMissing("hologram.tip.page", Locale.GERMANY, "<italic><gray>Tipp <page>/<pages></gray></italic>");
    }

    private void registerIfMissing(String key, Locale locale, String value) {
        if (this.contains(key, locale)) {
            return;
        }
        this.register(key, locale, value);
        this.save(locale);
    }

    public TranslatableComponentRenderer<Locale> getRenderer() {
        return this.renderer;
    }

    public boolean read() {
        boolean bl;
        block9: {
            if (!Files.isDirectory(this.path, new LinkOption[0])) {
                return false;
            }
            Stream<Path> files = Files.list(this.path);
            try {
                this.unregisterAll();
                files.filter(path -> path.getFileName().toString().endsWith(".properties")).forEach(this::readLocale);
                bl = true;
                if (files == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (files != null) {
                        try {
                            files.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    this.plugin.getComponentLogger().warn("Failed to read custom translations", (Throwable)e);
                    return false;
                }
            }
            files.close();
        }
        return bl;
    }

    private void readLocale(Path path) {
        try (BufferedReader reader = Files.newBufferedReader(path);){
            Properties properties = new Properties();
            properties.load(reader);
            String string = path.getFileName().toString();
            String substring = string.substring(0, string.length() - ".properties".length());
            Locale locale = Translator.parseLocale((String)substring);
            if (locale == null) {
                this.plugin.getComponentLogger().warn("Invalid locale for {}", (Object)substring);
            } else {
                properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> this.register(key.toString(), locale, value.toString())));
            }
        }
        catch (IOException e) {
            this.plugin.getComponentLogger().warn("Failed to read custom translations from {}", (Object)path, (Object)e);
        }
    }

    public void save(Locale locale) {
        this.saveLocale(locale, this.getAllTranslations(locale));
    }

    private void saveLocale(Locale locale, Map<String, String> translations) {
        try {
            Files.createDirectories(this.path, new FileAttribute[0]);
            Path path = this.path.resolve(String.valueOf(locale) + ".properties");
            Properties properties = new Properties();
            translations.forEach(properties::setProperty);
            String comment = LanguageTags.getLanguageName(locale);
            properties.store(Files.newBufferedWriter(path, new OpenOption[0]), comment);
        }
        catch (IOException e) {
            this.plugin.getComponentLogger().warn("Failed to save translations for locale {}", (Object)locale, (Object)e);
        }
    }
}

