/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.hologram.listeners;

import io.papermc.paper.event.entity.EntityKnockbackEvent;
import io.papermc.paper.event.player.PlayerPickEntityEvent;
import io.papermc.paper.event.player.PrePlayerAttackEntityEvent;
import java.util.function.BiConsumer;
import net.thenextlvl.hologram.Hologram;
import net.thenextlvl.hologram.HologramPlugin;
import net.thenextlvl.hologram.action.ClickAction;
import net.thenextlvl.hologram.action.ClickType;
import net.thenextlvl.hologram.line.HologramLine;
import net.thenextlvl.hologram.line.PagedHologramLine;
import net.thenextlvl.hologram.models.line.PaperEntityHologramLine;
import net.thenextlvl.hologram.models.line.PaperHologramLine;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.CreeperPowerEvent;
import org.bukkit.event.entity.EntityCombustEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.player.PlayerArmorStandManipulateEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class EntityListener
implements Listener {
    private final HologramPlugin plugin;

    public EntityListener(HologramPlugin plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onEntityCombust(EntityCombustEvent event) {
        event.setCancelled(this.plugin.hologramProvider().isHologramPart(event.getEntity()));
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onEntityDeath(EntityDeathEvent event) {
        event.setCancelled(this.plugin.hologramProvider().isHologramPart((Entity)event.getEntity()));
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onEntityDamage(EntityDamageEvent event) {
        Entity entity = event.getDamageSource().getCausingEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            this.handleInteraction(player, event.getEntity(), (Cancellable)event, false);
        } else {
            entity = event.getDamageSource().getDirectEntity();
            if (entity instanceof Player) {
                Player player = (Player)entity;
                this.handleInteraction(player, event.getEntity(), (Cancellable)event, false);
            } else {
                event.setCancelled(this.plugin.hologramProvider().isHologramPart(event.getEntity()));
            }
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onEntityDamage(EntityDamageByEntityEvent event) {
        Entity entity = event.getDamager();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            this.handleInteraction(player, event.getEntity(), (Cancellable)event, false);
        } else {
            event.setCancelled(this.plugin.hologramProvider().isHologramPart(event.getEntity()));
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onPrePlayerEntityAttack(PrePlayerAttackEntityEvent event) {
        this.handleInteraction(event.getPlayer(), event.getAttacked(), (Cancellable)event, false);
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onPlayerPickEntity(PlayerPickEntityEvent event) {
        event.setCancelled(this.plugin.hologramProvider().isHologramPart(event.getEntity()));
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onPlayerArmorStandManipulate(PlayerArmorStandManipulateEvent event) {
        event.setCancelled(this.plugin.hologramProvider().isHologramPart((Entity)event.getRightClicked()));
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerInteractEntity(PlayerInteractEntityEvent event) {
        this.handleInteraction(event.getPlayer(), event.getRightClicked(), (Cancellable)event, true);
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onCreeperPower(CreeperPowerEvent event) {
        event.setCancelled(this.plugin.hologramProvider().isHologramPart((Entity)event.getEntity()));
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onProjectileHit(ProjectileHitEvent event) {
        event.setCancelled(event.getHitEntity() != null && this.plugin.hologramProvider().isHologramPart(event.getHitEntity()));
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onEntityKnockback(EntityKnockbackEvent event) {
        event.setCancelled(this.plugin.hologramProvider().isHologramPart(event.getEntity()));
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onChunkUnload(EntityRemoveEvent event) {
        this.plugin.hologramProvider().getHologramLine(event.getEntity()).map(hologram -> (PaperHologramLine)hologram).ifPresent(hologram -> hologram.invalidate(event.getEntity()));
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerMove(PlayerMoveEvent event) {
        this.plugin.hologramProvider().getHolograms(event.getPlayer()).flatMap(Hologram::getLines).filter(PaperEntityHologramLine.class::isInstance).map(PaperEntityHologramLine.class::cast).forEach(line -> line.applyBillboard(event.getPlayer()));
    }

    private void handleInteraction(Player player, Entity entity, Cancellable cancellable, boolean isRight) {
        this.plugin.hologramProvider().getHologramLine(entity).ifPresent(hologramLine -> {
            ClickType type = player.isSneaking() ? (isRight ? ClickType.SHIFT_RIGHT : ClickType.SHIFT_LEFT) : (isRight ? ClickType.RIGHT : ClickType.LEFT);
            BiConsumer<String, ClickAction> consumer = (name, action) -> {
                if (action.isSupportedClickType(type)) {
                    action.invoke((HologramLine)hologramLine, player);
                }
            };
            if (hologramLine instanceof PagedHologramLine) {
                PagedHologramLine paged = (PagedHologramLine)hologramLine;
                paged.forEachPage(page -> page.forEachAction(consumer));
            }
            hologramLine.forEachAction(consumer);
            cancellable.setCancelled(true);
        });
    }
}

