/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.hologram.controller;

import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import net.thenextlvl.hologram.HologramPlugin;
import net.thenextlvl.hologram.models.line.PaperPagedHologramLine;
import org.bukkit.plugin.Plugin;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public final class HologramTickPool {
    private final Set<PaperPagedHologramLine> registeredLines = ConcurrentHashMap.newKeySet();
    private final HologramPlugin plugin;
    private volatile @Nullable ScheduledTask cycleTask = null;

    public HologramTickPool(HologramPlugin plugin) {
        this.plugin = plugin;
    }

    public boolean register(PaperPagedHologramLine line) {
        if (!this.registeredLines.add(line)) {
            return false;
        }
        this.startTaskIfNeeded();
        return true;
    }

    public boolean unregister(PaperPagedHologramLine line) {
        if (!this.registeredLines.remove(line)) {
            return false;
        }
        this.stopTaskIfEmpty();
        return true;
    }

    private void startTaskIfNeeded() {
        if (this.cycleTask != null || this.registeredLines.isEmpty()) {
            return;
        }
        this.cycleTask = this.plugin.getServer().getAsyncScheduler().runAtFixedRate((Plugin)this.plugin, this::tick, 50L, 50L, TimeUnit.MILLISECONDS);
    }

    private void stopTaskIfEmpty() {
        if (!this.registeredLines.isEmpty()) {
            return;
        }
        ScheduledTask task = this.cycleTask;
        if (task != null) {
            task.cancel();
            this.cycleTask = null;
        }
    }

    private void tick(ScheduledTask task) {
        long now = System.currentTimeMillis();
        this.registeredLines.forEach(line -> line.tickCycle(now));
    }

    public void shutdown() {
        ScheduledTask task = this.cycleTask;
        if (task != null) {
            task.cancel();
            this.cycleTask = null;
        }
        this.registeredLines.clear();
    }
}

