/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.hologram.commands.page;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import io.papermc.paper.command.brigadier.argument.ArgumentTypes;
import io.papermc.paper.registry.RegistryKey;
import java.util.function.BiConsumer;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.minimessage.tag.resolver.Formatter;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.thenextlvl.hologram.Hologram;
import net.thenextlvl.hologram.HologramPlugin;
import net.thenextlvl.hologram.commands.HologramCommand;
import net.thenextlvl.hologram.commands.brigadier.BrigadierCommand;
import net.thenextlvl.hologram.commands.suggestions.LineSuggestionProvider;
import net.thenextlvl.hologram.commands.suggestions.PageSuggestionProvider;
import net.thenextlvl.hologram.line.HologramLine;
import net.thenextlvl.hologram.line.PagedHologramLine;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.BlockData;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.ItemStack;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class HologramPageInsertCommand
extends BrigadierCommand {
    private HologramPageInsertCommand(HologramPlugin plugin) {
        super(plugin, "insert", "holograms.command.page.insert");
    }

    public static LiteralArgumentBuilder<CommandSourceStack> create(HologramPlugin plugin) {
        HologramPageInsertCommand command = new HologramPageInsertCommand(plugin);
        RequiredArgumentBuilder line = Commands.argument((String)"line", (ArgumentType)IntegerArgumentType.integer((int)1)).suggests((SuggestionProvider)LineSuggestionProvider.PAGED_ONLY);
        RequiredArgumentBuilder page = Commands.argument((String)"page", (ArgumentType)IntegerArgumentType.integer((int)1)).suggests((SuggestionProvider)PageSuggestionProvider.INSTANCE);
        return (LiteralArgumentBuilder)command.create().then(HologramCommand.hologramArgument(plugin, true).then(line.then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)page.then(command.insertPage("block", ArgumentTypes.blockState(), command::insertBlockPage, plugin))).then(command.insertPage("entity", ArgumentTypes.resource((RegistryKey)RegistryKey.ENTITY_TYPE), command::insertEntityPage, plugin))).then(command.insertPage("item", ArgumentTypes.itemStack(), command::insertItemPage, plugin))).then(command.insertPage("text", (ArgumentType<?>)StringArgumentType.greedyString(), command::insertTextPage, plugin)))));
    }

    private LiteralArgumentBuilder<CommandSourceStack> insertPage(String name, ArgumentType<?> argumentType, BiConsumer<PagedHologramLine, CommandContext<CommandSourceStack>> inserter, HologramPlugin plugin) {
        return (LiteralArgumentBuilder)Commands.literal((String)name).then(Commands.argument((String)name, argumentType).executes(context -> this.insertPage((CommandContext<CommandSourceStack>)context, plugin, inserter)));
    }

    private int insertPage(CommandContext<CommandSourceStack> context, HologramPlugin plugin, BiConsumer<PagedHologramLine, CommandContext<CommandSourceStack>> inserter) {
        CommandSender sender = ((CommandSourceStack)context.getSource()).getSender();
        Hologram hologram = (Hologram)context.getArgument("hologram", Hologram.class);
        int lineIndex = (Integer)context.getArgument("line", Integer.TYPE) - 1;
        int pageIndex = (Integer)context.getArgument("page", Integer.TYPE) - 1;
        HologramLine line = hologram.getLine(lineIndex).orElse(null);
        if (line == null) {
            plugin.bundle().sendMessage((Audience)sender, "hologram.line.invalid");
            return 0;
        }
        if (!(line instanceof PagedHologramLine)) {
            plugin.bundle().sendMessage((Audience)sender, "hologram.type.paged");
            return 0;
        }
        PagedHologramLine pagedLine = (PagedHologramLine)line;
        if (pageIndex < 0 || pageIndex > pagedLine.getPageCount()) {
            plugin.bundle().sendMessage((Audience)sender, "hologram.page.invalid", new TagResolver[]{Placeholder.unparsed((String)"hologram", (String)hologram.getName()), Formatter.number((String)"line", (Number)(lineIndex + 1)), Formatter.number((String)"page", (Number)(pageIndex + 1))});
            return 0;
        }
        inserter.accept(pagedLine, context);
        plugin.bundle().sendMessage((Audience)sender, "hologram.page.insert", new TagResolver[]{Placeholder.unparsed((String)"hologram", (String)hologram.getName()), Formatter.number((String)"line", (Number)(lineIndex + 1)), Formatter.number((String)"page", (Number)(pageIndex + 1))});
        return 1;
    }

    private void insertBlockPage(PagedHologramLine pagedLine, CommandContext<CommandSourceStack> context) {
        BlockData block = ((BlockState)context.getArgument("block", BlockState.class)).getBlockData();
        int pageIndex = (Integer)context.getArgument("page", Integer.TYPE) - 1;
        pagedLine.insertBlockPage(pageIndex).setBlock(block);
    }

    private void insertEntityPage(PagedHologramLine pagedLine, CommandContext<CommandSourceStack> context) {
        EntityType entity = (EntityType)context.getArgument("entity", EntityType.class);
        int pageIndex = (Integer)context.getArgument("page", Integer.TYPE) - 1;
        pagedLine.insertEntityPage(pageIndex, entity);
    }

    private void insertItemPage(PagedHologramLine pagedLine, CommandContext<CommandSourceStack> context) {
        ItemStack item = (ItemStack)context.getArgument("item", ItemStack.class);
        int pageIndex = (Integer)context.getArgument("page", Integer.TYPE) - 1;
        pagedLine.insertItemPage(pageIndex).setItemStack(item);
    }

    private void insertTextPage(PagedHologramLine pagedLine, CommandContext<CommandSourceStack> context) {
        String text = (String)context.getArgument("text", String.class);
        int pageIndex = (Integer)context.getArgument("page", Integer.TYPE) - 1;
        pagedLine.insertTextPage(pageIndex).setUnparsedText(text);
    }
}

