/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.hologram.commands.edit;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import java.util.Optional;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.minimessage.tag.resolver.Formatter;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.thenextlvl.hologram.HologramPlugin;
import net.thenextlvl.hologram.commands.edit.EditCommand;
import net.thenextlvl.hologram.commands.edit.LineTargetResolver;
import org.bukkit.entity.Display;
import org.jspecify.annotations.NullMarked;

@NullMarked
final class EditBrightnessCommand
extends EditCommand {
    private EditBrightnessCommand(HologramPlugin plugin, LineTargetResolver.Builder resolver) {
        super(plugin, "brightness", resolver);
    }

    public static LiteralArgumentBuilder<CommandSourceStack> create(HologramPlugin plugin, LineTargetResolver.Builder resolver) {
        EditBrightnessCommand command = new EditBrightnessCommand(plugin, resolver);
        IntegerArgumentType argument = IntegerArgumentType.integer((int)0, (int)15);
        RequiredArgumentBuilder brightness = Commands.argument((String)"brightness", (ArgumentType)argument);
        RequiredArgumentBuilder blockLight = Commands.argument((String)"block light", (ArgumentType)argument);
        RequiredArgumentBuilder skyLight = Commands.argument((String)"sky light", (ArgumentType)argument);
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)command.create().then(brightness.executes((Command)command))).then(blockLight.then(skyLight.executes((Command)command)))).then(Commands.literal((String)"reset").executes(command::reset))).executes((Command)command);
    }

    private int reset(CommandContext<CommandSourceStack> context) {
        LineTargetResolver resolver = this.resolver.build(context, this.plugin);
        return resolver.resolve((hologram, line, lineIndex, pageIndex, placeholders) -> {
            String message = this.set(line.getBrightness().orElse(null), null, line::setBrightness, "hologram.brightness.reset");
            this.plugin.bundle().sendMessage((Audience)((CommandSourceStack)context.getSource()).getSender(), message, placeholders);
            return 1;
        }, LineTargetResolver.LineType.DISPLAY);
    }

    @Override
    public int run(CommandContext<CommandSourceStack> context, LineTargetResolver resolver) throws CommandSyntaxException {
        return resolver.resolve((hologram, line, lineIndex, pageIndex, placeholders) -> {
            Optional<Display.Brightness> brightness = this.tryGetArgument(context, "brightness", Integer.TYPE).map(b -> new Display.Brightness(b.intValue(), b.intValue())).or(() -> this.tryGetArgument(context, "block light", Integer.TYPE).map(blockLight -> {
                Integer skyLight = (Integer)context.getArgument("sky light", Integer.TYPE);
                return new Display.Brightness(blockLight.intValue(), skyLight.intValue());
            }));
            Display.Brightness ored = brightness.or(line::getBrightness).orElse(null);
            String message = brightness.map(value -> this.set(line.getBrightness().orElse(null), value, line::setBrightness, "hologram.brightness")).orElse(ored != null ? "hologram.brightness.query" : "hologram.brightness.query.none");
            this.plugin.bundle().sendMessage((Audience)((CommandSourceStack)context.getSource()).getSender(), message, TagResolver.resolver((TagResolver[])placeholders), Formatter.number((String)"block_light", (Number)(ored != null ? ored.getBlockLight() : -1)), Formatter.number((String)"sky_light", (Number)(ored != null ? ored.getSkyLight() : -1)));
            return 1;
        }, LineTargetResolver.LineType.DISPLAY);
    }
}

