/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.hologram.commands.edit;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import java.util.Optional;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.thenextlvl.hologram.HologramPlugin;
import net.thenextlvl.hologram.commands.arguments.EnumArgumentType;
import net.thenextlvl.hologram.commands.edit.EditCommand;
import net.thenextlvl.hologram.commands.edit.LineTargetResolver;
import net.thenextlvl.i18n.ComponentBundle;
import org.bukkit.entity.TextDisplay;
import org.jspecify.annotations.NullMarked;

@NullMarked
final class EditAlignmentCommand
extends EditCommand {
    private EditAlignmentCommand(HologramPlugin plugin, LineTargetResolver.Builder resolver) {
        super(plugin, "alignment", resolver);
    }

    public static LiteralArgumentBuilder<CommandSourceStack> create(HologramPlugin plugin, LineTargetResolver.Builder resolver) {
        EditAlignmentCommand command = new EditAlignmentCommand(plugin, resolver);
        RequiredArgumentBuilder named = Commands.argument((String)"alignment", new EnumArgumentType<TextDisplay.TextAlignment>(TextDisplay.TextAlignment.class));
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)command.create().then(named.executes((Command)command))).executes((Command)command);
    }

    @Override
    public int run(CommandContext<CommandSourceStack> context, LineTargetResolver resolver) throws CommandSyntaxException {
        return resolver.resolve((hologram, line, lineIndex, pageIndex, placeholders) -> {
            Optional<TextDisplay.TextAlignment> alignment = this.tryGetArgument(context, "alignment", TextDisplay.TextAlignment.class);
            ComponentBundle componentBundle = this.plugin.bundle();
            Component alignmentName = componentBundle.component(switch (alignment.orElseGet(line::getAlignment)) {
                default -> throw new MatchException(null, null);
                case TextDisplay.TextAlignment.LEFT -> "text-alignment.left";
                case TextDisplay.TextAlignment.CENTER -> "text-alignment.center";
                case TextDisplay.TextAlignment.RIGHT -> "text-alignment.right";
            }, (Audience)((CommandSourceStack)context.getSource()).getSender());
            String message = alignment.map(textAlignment -> this.set(line.getAlignment(), textAlignment, line::setAlignment, "hologram.text-alignment")).orElse("hologram.alignment.query");
            this.plugin.bundle().sendMessage((Audience)((CommandSourceStack)context.getSource()).getSender(), message, new TagResolver[]{TagResolver.resolver((TagResolver[])placeholders), Placeholder.component((String)"alignment", (ComponentLike)alignmentName)});
            return 1;
        }, LineTargetResolver.LineType.TEXT);
    }
}

