/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.hologram.commands.action;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.thenextlvl.hologram.Hologram;
import net.thenextlvl.hologram.HologramPlugin;
import net.thenextlvl.hologram.action.ClickAction;
import net.thenextlvl.hologram.commands.action.ActionTargetResolver;
import net.thenextlvl.hologram.commands.brigadier.SimpleCommand;
import net.thenextlvl.hologram.commands.suggestions.HologramActionSuggestionProvider;
import net.thenextlvl.hologram.line.HologramLine;
import org.bukkit.command.CommandSender;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
abstract class ActionCommand
extends SimpleCommand {
    protected final ActionTargetResolver.Builder resolverBuilder;

    protected ActionCommand(HologramPlugin plugin, String name, @Nullable String permission, ActionTargetResolver.Builder resolverBuilder) {
        super(plugin, name, permission);
        this.resolverBuilder = resolverBuilder;
    }

    public final int run(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        return this.resolverBuilder.build(context, this.plugin).resolve((hologram, line, lineIndex, pageIndex, placeholders) -> {
            CommandSender sender = ((CommandSourceStack)context.getSource()).getSender();
            String actionName = (String)context.getArgument("action", String.class);
            ClickAction action = line.getAction(actionName).orElse(null);
            if (action == null) {
                this.plugin.bundle().sendMessage((Audience)sender, "hologram.action.not_found", new TagResolver[]{Placeholder.parsed((String)"hologram", (String)hologram.getName()), Placeholder.unparsed((String)"action", (String)actionName)});
                return 0;
            }
            return this.run(context, hologram, line, action, actionName, placeholders);
        });
    }

    public abstract int run(CommandContext<CommandSourceStack> var1, Hologram var2, HologramLine var3, ClickAction<?> var4, String var5, TagResolver ... var6) throws CommandSyntaxException;

    protected static ArgumentBuilder<CommandSourceStack, ?> actionArgument(HologramPlugin plugin) {
        return Commands.argument((String)"action", (ArgumentType)StringArgumentType.word()).suggests((SuggestionProvider)new HologramActionSuggestionProvider());
    }
}

