/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.hologram.locale;

import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import net.kyori.adventure.translation.Translator;
import org.jspecify.annotations.Nullable;

public final class LanguageTags {
    private static final Map<String, String> LANGUAGE_TAGS = Map.ofEntries(Map.entry("English", "en_US"), Map.entry("Afrikaans", "af"), Map.entry("Albanian", "sq_AL"), Map.entry("Allgovian German", "swg"), Map.entry("Andalusian", "esan"), Map.entry("Anglish", "enp"), Map.entry("Arabic", "ar"), Map.entry("Aragonese", "an"), Map.entry("Armenian", "hy_AM"), Map.entry("Asturian", "ast"), Map.entry("Avaric", "av"), Map.entry("Azerbaijani", "az"), Map.entry("Bashkir", "ba_RU"), Map.entry("Bashkir (Yurmaty)", "bak"), Map.entry("Basque", "eu_ES"), Map.entry("Bavarian", "bar"), Map.entry("Belarusian", "be_BY"), Map.entry("Belarusian (Latin)", "be_LATN"), Map.entry("Bengali", "bn"), Map.entry("Bosnian", "bs_BA"), Map.entry("Brabantian", "brb"), Map.entry("Breton", "br_FR"), Map.entry("Bulgarian", "bg_BG"), Map.entry("Cantabrian", "qcb_ES"), Map.entry("Catalan", "ca_ES"), Map.entry("Chechen", "ce"), Map.entry("Chinese Simplified", "zh_CN"), Map.entry("Chinese Traditional", "zh_TW"), Map.entry("Chinese Traditional, Hong Kong", "zh_HK"), Map.entry("Chinook Jargon", "chk"), Map.entry("Chuvash", "cv"), Map.entry("Classical Chinese", "lzh"), Map.entry("Cornish", "kw_GB"), Map.entry("Croatian", "hr_HR"), Map.entry("Czech", "cs_CZ"), Map.entry("Danish", "da_DK"), Map.entry("Dutch", "nl_NL"), Map.entry("Dutch, Belgium", "nl_BE"), Map.entry("Elfdalian", "ovd"), Map.entry("Emilian", "egl"), Map.entry("English (upside down)", "en_UD"), Map.entry("English, Australia", "en_AU"), Map.entry("English, Canada", "en_CA"), Map.entry("English, New Zealand", "en_NZ"), Map.entry("English, United Kingdom", "en_GB"), Map.entry("Esperanto", "eo_UY"), Map.entry("Estonian", "et_EE"), Map.entry("Eudeve", "eud"), Map.entry("Faroese", "fo_FO"), Map.entry("Filipino", "fil_PH"), Map.entry("Finnish", "fi_FI"), Map.entry("Franconian", "fra_DE"), Map.entry("French", "fr_FR"), Map.entry("French, Canada", "fr_CA"), Map.entry("Frisian", "fy_NL"), Map.entry("Friulian", "fur_IT"), Map.entry("Galician", "gl_ES"), Map.entry("Gallo", "go"), Map.entry("Georgian", "ka_GE"), Map.entry("German", "de_DE"), Map.entry("German, Austria", "de_AT"), Map.entry("German, Switzerland", "de_CH"), Map.entry("Gothic", "got"), Map.entry("Greek", "el_GR"), Map.entry("Guarani", "gn"), Map.entry("Halychian", "hal_UA"), Map.entry("Hawaiian", "haw_US"), Map.entry("Hebrew", "he_IL"), Map.entry("Hessian", "hes"), Map.entry("High Norwegian", "hn_NO"), Map.entry("Hindi", "hi_IN"), Map.entry("Hungarian", "hu_HU"), Map.entry("Icelandic", "is_IS"), Map.entry("Ido", "io_EN"), Map.entry("Igbo", "ig_NG"), Map.entry("Indonesian", "id_ID"), Map.entry("Indonesian (pre-reform)", "qid"), Map.entry("Innu", "moe"), Map.entry("Interslavic", "isv"), Map.entry("Irish", "ga_IE"), Map.entry("Italian", "it_IT"), Map.entry("Japanese", "ja_JP"), Map.entry("Jerriais", "je"), Map.entry("Kabyle", "kab"), Map.entry("Kannada", "kn_IN"), Map.entry("Kashubian", "csb"), Map.entry("Kazakh", "kk_KZ"), Map.entry("Kildin Sami", "sjd"), Map.entry("Klingon", "tlh_AA"), Map.entry("Korean", "ko_KR"), Map.entry("Kyrgyz", "ky_KG"), Map.entry("Lao", "lo_LA"), Map.entry("Latin", "la_LA"), Map.entry("Latvian", "lv_LV"), Map.entry("Limburgish", "li_LI"), Map.entry("Lithuanian", "lt_LT"), Map.entry("Lojban", "jbo_EN"), Map.entry("LOLCAT", "lol_US"), Map.entry("Lombard", "lmo"), Map.entry("Low German", "nds_DE"), Map.entry("Lower Sorbian", "dsb_DE"), Map.entry("Luxembourgish", "lb_LU"), Map.entry("Macedonian", "mk_MK"), Map.entry("Malay", "ms_MY"), Map.entry("Malay (Jawi)", "zlm_ARAB"), Map.entry("Maltese", "mt_MT"), Map.entry("Manx", "gv"), Map.entry("Maori", "mi"), Map.entry("Mapudungun", "arn"), Map.entry("Mohawk", "moh"), Map.entry("Mongolian", "mn_MN"), Map.entry("Montenegrin (Cyrillic)", "sr_Cyrl_ME"), Map.entry("Montenegrin (Latin)", "me"), Map.entry("Nahuatl", "nah"), Map.entry("Neapolitan", "nap"), Map.entry("Nepali", "ne_NP"), Map.entry("Northern Sami", "se_NO"), Map.entry("Norwegian", "no_NO"), Map.entry("Norwegian Nynorsk", "nn_NO"), Map.entry("Nuu-chah-nulth", "nuk"), Map.entry("Occitan", "oc_FR"), Map.entry("Ojibwe", "oj"), Map.entry("Persian", "fa_IR"), Map.entry("Pirate English", "en_PT"), Map.entry("Polish", "pl_PL"), Map.entry("Popoloca", "pls"), Map.entry("Portuguese", "pt_PT"), Map.entry("Portuguese, Angolan", "ao"), Map.entry("Portuguese, Brazilian", "pt_BR"), Map.entry("Punjabi", "pa_IN"), Map.entry("Quenya", "qya_AA"), Map.entry("Ripuarian", "ksh"), Map.entry("Romanian", "ro_RO"), Map.entry("Russian", "ru_RU"), Map.entry("Russian (pre-revolutionary)", "rpr"), Map.entry("Rusyn", "ry_UA"), Map.entry("Sakha", "sah_SAH"), Map.entry("Scottish Gaelic", "gd_GB"), Map.entry("Serbian (Cyrillic)", "sr_SP"), Map.entry("Serbian (Latin)", "sr_CS"), Map.entry("Shakespearean English", "enws"), Map.entry("Sicilian", "scn"), Map.entry("Silesian", "szl"), Map.entry("Silesian (Opole)", "szl_OP"), Map.entry("Slovak", "sk_SK"), Map.entry("Slovenian", "sl_SI"), Map.entry("Somali", "so_SO"), Map.entry("Sorani (Kurdish)", "ckb"), Map.entry("Spanish", "es_ES"), Map.entry("Spanish, Argentina", "es_AR"), Map.entry("Spanish, Chile", "es_CL"), Map.entry("Spanish, Colombia", "es_CO"), Map.entry("Spanish, Costa Rica", "es_CR"), Map.entry("Spanish, Ecuador", "es_EC"), Map.entry("Spanish, Mexico", "es_MX"), Map.entry("Spanish, Peru", "es_PE"), Map.entry("Spanish, Uruguay", "es_UY"), Map.entry("Spanish, Venezuela", "es_VE"), Map.entry("Swedish", "sv_SE"), Map.entry("Tagalog", "tl_PH"), Map.entry("Talossan", "tzl"), Map.entry("Tamil", "ta_IN"), Map.entry("Tatar", "tt_RU"), Map.entry("Thai", "th_TH"), Map.entry("Toki Pona", "tok"), Map.entry("Turkish", "tr_TR"), Map.entry("Tzotzil", "tzo_MX"), Map.entry("Ukrainian", "uk_UA"), Map.entry("Upper Saxon German", "sxu"), Map.entry("Upper Sorbian", "hsb_DE"), Map.entry("Urdu (Pakistan)", "ur_PK"), Map.entry("Uyghur", "ug"), Map.entry("Uzbek", "uz"), Map.entry("Valencian", "val_ES"), Map.entry("Venetian", "vec_IT"), Map.entry("Vietnamese", "vi_VN"), Map.entry("Viossa", "vp_VL"), Map.entry("Voro", "vro"), Map.entry("Welsh", "cy_GB"), Map.entry("Yiddish", "yi_DE"), Map.entry("Yoruba", "yo_NG"));

    public static Stream<Map.Entry<Locale, String>> getLanguages() {
        return LANGUAGE_TAGS.entrySet().stream().map(entry -> {
            Locale locale = Translator.parseLocale((String)((String)entry.getValue()));
            if (locale == null) {
                return null;
            }
            return Map.entry(locale, (String)entry.getKey());
        }).filter(Objects::nonNull);
    }

    public static @Nullable Locale getLocale(String languageName) {
        String value = LANGUAGE_TAGS.get(languageName);
        return value != null ? Translator.parseLocale((String)value) : null;
    }

    public static String getLanguageName(Locale locale) {
        return LANGUAGE_TAGS.keySet().stream().filter(s -> locale.equals(LanguageTags.getLocale(s))).findAny().orElse(locale.toString());
    }
}

