/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.hologram.commands.page;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.minimessage.tag.resolver.Formatter;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.kyori.adventure.translation.Translatable;
import net.thenextlvl.hologram.Hologram;
import net.thenextlvl.hologram.HologramPlugin;
import net.thenextlvl.hologram.commands.HologramCommand;
import net.thenextlvl.hologram.commands.brigadier.BrigadierCommand;
import net.thenextlvl.hologram.commands.suggestions.LineSuggestionProvider;
import net.thenextlvl.hologram.line.BlockHologramLine;
import net.thenextlvl.hologram.line.EntityHologramLine;
import net.thenextlvl.hologram.line.HologramLine;
import net.thenextlvl.hologram.line.ItemHologramLine;
import net.thenextlvl.hologram.line.PagedHologramLine;
import net.thenextlvl.hologram.line.StaticHologramLine;
import net.thenextlvl.hologram.line.TextHologramLine;
import org.bukkit.command.CommandSender;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class HologramPageListCommand
extends BrigadierCommand {
    private HologramPageListCommand(HologramPlugin plugin) {
        super(plugin, "list", "holograms.command.page.list");
    }

    public static LiteralArgumentBuilder<CommandSourceStack> create(HologramPlugin plugin) {
        HologramPageListCommand command = new HologramPageListCommand(plugin);
        RequiredArgumentBuilder line = Commands.argument((String)"line", (ArgumentType)IntegerArgumentType.integer((int)1)).suggests((SuggestionProvider)LineSuggestionProvider.PAGED_ONLY);
        return (LiteralArgumentBuilder)command.create().then(HologramCommand.hologramArgument(plugin, true).then(line.executes(command::listPages)));
    }

    private int listPages(CommandContext<CommandSourceStack> context) {
        int lineIndex;
        CommandSender sender = ((CommandSourceStack)context.getSource()).getSender();
        Hologram hologram = (Hologram)context.getArgument("hologram", Hologram.class);
        HologramLine line = hologram.getLine(lineIndex = (Integer)context.getArgument("line", Integer.TYPE) - 1).orElse(null);
        if (line == null) {
            this.plugin.bundle().sendMessage((Audience)sender, "hologram.line.invalid");
            return 0;
        }
        if (!(line instanceof PagedHologramLine)) {
            this.plugin.bundle().sendMessage((Audience)sender, "hologram.type.paged");
            return 0;
        }
        PagedHologramLine pagedLine = (PagedHologramLine)line;
        this.plugin.bundle().sendMessage((Audience)sender, "hologram.page.list.header", new TagResolver[]{Placeholder.unparsed((String)"hologram", (String)hologram.getName()), Formatter.number((String)"line", (Number)(lineIndex + 1)), Formatter.number((String)"count", (Number)pagedLine.getPageCount())});
        for (int index = 0; index < pagedLine.getPageCount(); ++index) {
            StaticHologramLine page = pagedLine.getPage(index).orElse(null);
            if (page == null) continue;
            this.plugin.bundle().sendMessage((Audience)sender, "hologram.page.list.entry", new TagResolver[]{Formatter.number((String)"index", (Number)(index + 1)), Placeholder.unparsed((String)"type", (String)this.getPageType(page)), Placeholder.component((String)"preview", (ComponentLike)this.getPagePreview(page))});
        }
        return 1;
    }

    private String getPageType(HologramLine page) {
        HologramLine hologramLine = page;
        Objects.requireNonNull(hologramLine);
        HologramLine hologramLine2 = hologramLine;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{TextHologramLine.class, ItemHologramLine.class, BlockHologramLine.class, EntityHologramLine.class}, (Object)hologramLine2, n)) {
            case 0 -> {
                TextHologramLine ignored = (TextHologramLine)hologramLine2;
                yield "text";
            }
            case 1 -> {
                ItemHologramLine ignored = (ItemHologramLine)hologramLine2;
                yield "item";
            }
            case 2 -> {
                BlockHologramLine ignored = (BlockHologramLine)hologramLine2;
                yield "block";
            }
            case 3 -> {
                EntityHologramLine ignored = (EntityHologramLine)hologramLine2;
                yield "entity";
            }
            default -> "unknown";
        };
    }

    private Component getPagePreview(HologramLine page) {
        HologramLine hologramLine = page;
        Objects.requireNonNull(hologramLine);
        HologramLine hologramLine2 = hologramLine;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{TextHologramLine.class, ItemHologramLine.class, BlockHologramLine.class, EntityHologramLine.class}, (Object)hologramLine2, n)) {
            case 0 -> {
                TextHologramLine textLine = (TextHologramLine)hologramLine2;
                yield Component.text((String)textLine.getUnparsedText().orElse("(empty)"));
            }
            case 1 -> {
                ItemHologramLine itemLine = (ItemHologramLine)hologramLine2;
                yield Component.translatable((Translatable)itemLine.getItemStack());
            }
            case 2 -> {
                BlockHologramLine blockLine = (BlockHologramLine)hologramLine2;
                yield Component.text((String)blockLine.getBlock().getMaterial().name());
            }
            case 3 -> {
                EntityHologramLine entityLine = (EntityHologramLine)hologramLine2;
                yield Component.text((String)entityLine.getEntityType().name());
            }
            default -> Component.text((String)"?");
        };
    }
}

