/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.hologram.commands.edit;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import java.util.Optional;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.thenextlvl.hologram.HologramPlugin;
import net.thenextlvl.hologram.commands.arguments.EnumArgumentType;
import net.thenextlvl.hologram.commands.edit.EditCommand;
import net.thenextlvl.hologram.commands.edit.LineTargetResolver;
import net.thenextlvl.i18n.ComponentBundle;
import org.bukkit.entity.Display;
import org.jspecify.annotations.NullMarked;

@NullMarked
final class EditBillboardCommand
extends EditCommand {
    private EditBillboardCommand(HologramPlugin plugin, LineTargetResolver.Builder resolver) {
        super(plugin, "billboard", resolver);
    }

    public static LiteralArgumentBuilder<CommandSourceStack> create(HologramPlugin plugin, LineTargetResolver.Builder resolver) {
        EditBillboardCommand command = new EditBillboardCommand(plugin, resolver);
        RequiredArgumentBuilder named = Commands.argument((String)"billboard", new EnumArgumentType<Display.Billboard>(Display.Billboard.class));
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)command.create().then(named.executes((Command)command))).executes((Command)command);
    }

    @Override
    public int run(CommandContext<CommandSourceStack> context, LineTargetResolver resolver) throws CommandSyntaxException {
        return resolver.resolve((hologram, line, lineIndex, pageIndex, placeholders) -> {
            Optional<Display.Billboard> billboard = this.tryGetArgument(context, "billboard", Display.Billboard.class);
            ComponentBundle componentBundle = this.plugin.bundle();
            Component billboardName = componentBundle.component(switch (billboard.orElseGet(line::getBillboard)) {
                default -> throw new MatchException(null, null);
                case Display.Billboard.FIXED -> "billboard.fixed";
                case Display.Billboard.VERTICAL -> "billboard.vertical";
                case Display.Billboard.HORIZONTAL -> "billboard.horizontal";
                case Display.Billboard.CENTER -> "billboard.center";
            }, (Audience)((CommandSourceStack)context.getSource()).getSender());
            String message = billboard.map(value -> this.set(line.getBillboard(), value, line::setBillboard, "hologram.billboard")).orElse("hologram.billboard.query");
            this.plugin.bundle().sendMessage((Audience)((CommandSourceStack)context.getSource()).getSender(), message, new TagResolver[]{TagResolver.resolver((TagResolver[])placeholders), Placeholder.component((String)"billboard", (ComponentLike)billboardName)});
            return 1;
        }, LineTargetResolver.LineType.STATIC);
    }
}

