/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.hologram.commands.edit;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import net.kyori.adventure.audience.Audience;
import net.thenextlvl.hologram.HologramPlugin;
import net.thenextlvl.hologram.commands.edit.EditCommand;
import net.thenextlvl.hologram.commands.edit.LineTargetResolver;
import org.jspecify.annotations.NullMarked;

@NullMarked
final class EditAppendCommand
extends EditCommand {
    private EditAppendCommand(HologramPlugin plugin, LineTargetResolver.Builder resolver) {
        super(plugin, "append", resolver);
    }

    public static LiteralArgumentBuilder<CommandSourceStack> create(HologramPlugin plugin, LineTargetResolver.Builder resolver) {
        EditAppendCommand command = new EditAppendCommand(plugin, resolver);
        RequiredArgumentBuilder text = Commands.argument((String)"text", (ArgumentType)StringArgumentType.greedyString());
        return (LiteralArgumentBuilder)command.create().then(text.executes((Command)command));
    }

    @Override
    public int run(CommandContext<CommandSourceStack> context, LineTargetResolver resolver) throws CommandSyntaxException {
        return resolver.resolve((hologram, line, lineIndex, pageIndex, placeholders) -> {
            String text = (String)context.getArgument("text", String.class);
            String current = line.getUnparsedText().orElse(null);
            String newText = current == null ? text : current.concat(text);
            String message = this.set(current, newText, line::setUnparsedText, "hologram.text.set");
            this.plugin.bundle().sendMessage((Audience)((CommandSourceStack)context.getSource()).getSender(), message, placeholders);
            return 1;
        }, LineTargetResolver.LineType.TEXT);
    }
}

