/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.hologram.action;

import java.time.Duration;
import java.util.EnumSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadLocalRandom;
import net.thenextlvl.hologram.HologramPlugin;
import net.thenextlvl.hologram.action.ActionType;
import net.thenextlvl.hologram.action.ClickAction;
import net.thenextlvl.hologram.action.ClickType;
import net.thenextlvl.hologram.line.HologramLine;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Range;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
final class SimpleClickAction<T>
implements ClickAction<T> {
    private final Map<UUID, Long> cooldowns = new ConcurrentHashMap<UUID, Long>();
    private final HologramPlugin plugin;
    private final ActionType<T> actionType;
    private volatile EnumSet<ClickType> clickTypes;
    private volatile T input;
    private volatile @Range(from=0L, to=100L) int chance = 100;
    private volatile Duration cooldown = Duration.ZERO;
    private volatile @Nullable String permission = null;
    private volatile double cost = 0.0;

    public SimpleClickAction(HologramPlugin plugin, ActionType<T> actionType, EnumSet<ClickType> clickTypes, T input) {
        this.plugin = plugin;
        this.actionType = actionType;
        this.clickTypes = clickTypes;
        this.input = input;
    }

    @Override
    public ActionType<T> getActionType() {
        return this.actionType;
    }

    @Override
    public EnumSet<ClickType> getClickTypes() {
        return this.clickTypes;
    }

    @Override
    public boolean setClickTypes(EnumSet<ClickType> clickTypes) {
        if (Objects.equals(this.clickTypes, clickTypes)) {
            return false;
        }
        this.clickTypes = clickTypes;
        return true;
    }

    @Override
    public boolean isSupportedClickType(ClickType type) {
        return this.clickTypes.contains((Object)type);
    }

    @Override
    public T getInput() {
        return this.input;
    }

    @Override
    public boolean setInput(T input) {
        if (Objects.equals(this.input, input)) {
            return false;
        }
        this.input = input;
        return true;
    }

    @Override
    public @Range(from=0L, to=100L) int getChance() {
        return this.chance;
    }

    @Override
    public boolean setChance(@Range(from=0L, to=100L) int chance) {
        if (this.chance == chance) {
            return false;
        }
        this.chance = Math.clamp((long)chance, 0, 100);
        return true;
    }

    @Override
    public Optional<String> getPermission() {
        return Optional.ofNullable(this.permission);
    }

    @Override
    public boolean setPermission(@Nullable String permission) {
        if (Objects.equals(this.permission, permission)) {
            return false;
        }
        this.permission = permission;
        return true;
    }

    @Override
    public double getCost() {
        return this.cost;
    }

    @Override
    public boolean setCost(double cost) {
        if (this.cost == cost) {
            return false;
        }
        this.cost = cost;
        return true;
    }

    @Override
    public Duration getCooldown() {
        return this.cooldown;
    }

    @Override
    public boolean setCooldown(Duration cooldown) {
        if (Objects.equals(this.cooldown, cooldown)) {
            return false;
        }
        this.cooldown = cooldown;
        return true;
    }

    @Override
    public boolean isOnCooldown(Player player) {
        return this.cooldown.isPositive() && this.cooldowns.computeIfPresent(player.getUniqueId(), (ignored, lastUsed) -> {
            if (System.currentTimeMillis() - this.cooldown.toMillis() > lastUsed) {
                return null;
            }
            return lastUsed;
        }) != null;
    }

    @Override
    public boolean resetCooldown(Player player) {
        return this.cooldowns.remove(player.getUniqueId()) != null;
    }

    @Override
    public boolean invoke(HologramLine line, Player player) {
        if (this.isOnCooldown(player)) {
            return false;
        }
        if (!this.getPermission().map(arg_0 -> ((Player)player).hasPermission(arg_0)).orElse(true).booleanValue()) {
            return false;
        }
        if (ThreadLocalRandom.current().nextInt(100) > this.chance) {
            return false;
        }
        if (!this.plugin.economyProvider.withdraw(player, this.cost)) {
            return false;
        }
        this.actionType.action().invoke(line, player, this.input);
        if (this.cooldown.isPositive()) {
            this.cooldowns.put(player.getUniqueId(), System.currentTimeMillis());
        }
        return true;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleClickAction that = (SimpleClickAction)o;
        return this.chance == that.chance && Objects.equals(this.actionType, that.actionType) && Objects.equals(this.clickTypes, that.clickTypes) && Objects.equals(this.input, that.input) && Objects.equals(this.cooldown, that.cooldown) && Objects.equals(this.permission, that.permission);
    }

    public int hashCode() {
        return Objects.hash(this.actionType, this.clickTypes, this.input, this.chance, this.cooldown, this.permission);
    }
}

