/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.hologram;

import java.nio.file.Path;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import net.thenextlvl.hologram.line.BlockHologramLine;
import net.thenextlvl.hologram.line.EntityHologramLine;
import net.thenextlvl.hologram.line.HologramLine;
import net.thenextlvl.hologram.line.ItemHologramLine;
import net.thenextlvl.hologram.line.PagedHologramLine;
import net.thenextlvl.hologram.line.TextHologramLine;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Unmodifiable;
import org.jspecify.annotations.Nullable;

@ApiStatus.NonExtendable
public interface Hologram
extends Iterable<HologramLine> {
    @Contract(pure=true)
    public String getName();

    @Contract(mutates="this,io")
    public boolean setName(String var1);

    @Contract(value=" -> new", pure=true)
    public Location getLocation();

    @Contract(pure=true)
    public World getWorld();

    @Contract(mutates="this,io")
    public CompletableFuture<Boolean> teleportAsync(Location var1);

    @Contract(pure=true)
    public Stream<HologramLine> getLines();

    @Contract(pure=true)
    public int getLineCount();

    @Contract(pure=true)
    public Optional<HologramLine> getLine(int var1);

    @Contract(pure=true)
    public <T extends HologramLine> Optional<T> getLine(int var1, Class<T> var2);

    @Contract(pure=true)
    public int getLineIndex(HologramLine var1);

    @Contract(mutates="this")
    public boolean removeLine(HologramLine var1);

    @Contract(mutates="this")
    public boolean removeLine(int var1);

    @Contract(mutates="this")
    public boolean removeLines(Collection<HologramLine> var1);

    @Contract(mutates="this")
    public void clearLines();

    @Contract(pure=true)
    public boolean hasLine(HologramLine var1);

    @Contract(mutates="this")
    public boolean moveLine(int var1, int var2);

    @Contract(mutates="this")
    public boolean swapLines(int var1, int var2);

    @Contract(value="_ -> new", mutates="this")
    public EntityHologramLine addEntityLine(EntityType var1) throws IllegalArgumentException;

    @Contract(value="_ -> new", mutates="this")
    public EntityHologramLine addEntityLine(Class<? extends Entity> var1) throws IllegalArgumentException;

    @Contract(value="_, _ -> new", mutates="this")
    public EntityHologramLine addEntityLine(int var1, EntityType var2) throws IllegalArgumentException, IndexOutOfBoundsException;

    @Contract(value="_, _ -> new", mutates="this")
    public EntityHologramLine addEntityLine(int var1, Class<? extends Entity> var2) throws IllegalArgumentException, IndexOutOfBoundsException;

    @Contract(value=" -> new", mutates="this")
    public BlockHologramLine addBlockLine();

    @Contract(value="_ -> new", mutates="this")
    public BlockHologramLine addBlockLine(int var1) throws IndexOutOfBoundsException;

    @Contract(value=" -> new", mutates="this")
    public ItemHologramLine addItemLine();

    @Contract(value="_ -> new", mutates="this")
    public ItemHologramLine addItemLine(int var1) throws IndexOutOfBoundsException;

    @Contract(value=" -> new", mutates="this")
    public TextHologramLine addTextLine();

    @Contract(value="_ -> new", mutates="this")
    public TextHologramLine addTextLine(int var1) throws IndexOutOfBoundsException;

    @Contract(value=" -> new", mutates="this")
    public PagedHologramLine addPagedLine();

    @Contract(value="_ -> new", mutates="this")
    public PagedHologramLine addPagedLine(int var1) throws IndexOutOfBoundsException;

    @Contract(value="_ -> new", mutates="this")
    public PagedHologramLine setPagedLine(int var1) throws IndexOutOfBoundsException;

    @Contract(value="_, _ -> new", mutates="this")
    public EntityHologramLine setEntityLine(int var1, EntityType var2) throws IllegalArgumentException, IndexOutOfBoundsException;

    @Contract(value="_, _ -> new", mutates="this")
    public EntityHologramLine setEntityLine(int var1, Class<? extends Entity> var2) throws IllegalArgumentException, IndexOutOfBoundsException;

    @Contract(value="_ -> new", mutates="this")
    public BlockHologramLine setBlockLine(int var1) throws IndexOutOfBoundsException;

    @Contract(value="_ -> new", mutates="this")
    public ItemHologramLine setItemLine(int var1) throws IndexOutOfBoundsException;

    @Contract(value="_ -> new", mutates="this")
    public TextHologramLine setTextLine(int var1) throws IndexOutOfBoundsException;

    @Contract(pure=true)
    public Optional<String> getViewPermission();

    @Contract(mutates="this")
    public boolean setViewPermission(@Nullable String var1);

    @Contract(pure=true)
    public @Unmodifiable Set<UUID> getViewers();

    @Contract(mutates="this")
    public boolean addViewer(UUID var1);

    @Contract(mutates="this")
    public boolean addViewers(Collection<UUID> var1);

    @Contract(mutates="this")
    public boolean removeViewer(UUID var1);

    @Contract(mutates="this")
    public boolean removeViewers(Collection<UUID> var1);

    @Contract(pure=true)
    public boolean isViewer(UUID var1);

    @Contract(pure=true)
    public boolean canSee(Player var1);

    @Contract(pure=true)
    public boolean isVisibleByDefault();

    @Contract(mutates="this")
    public boolean setVisibleByDefault(boolean var1);

    @Contract(mutates="this")
    public boolean setPersistent(boolean var1);

    @Contract(pure=true)
    public boolean isPersistent();

    @Contract(mutates="io")
    public boolean persist();

    @Contract(pure=true)
    public Path getDataFile();

    @Contract(pure=true)
    public Path getBackupFile();

    @Contract(mutates="this")
    public CompletableFuture<Void> spawn();

    @Contract(mutates="this")
    public CompletableFuture<Boolean> spawn(Player var1);

    @Contract(mutates="this")
    public CompletableFuture<Void> despawn();

    @Contract(mutates="this")
    public CompletableFuture<Boolean> despawn(Player var1);

    @Contract(pure=true)
    public boolean isSpawned(Player var1);

    @Contract(pure=true)
    public boolean isPart(Entity var1);
}

