/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.utilities.utils;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import org.bukkit.entity.Player;

public enum Settings {
    ADVANCED_FLY,
    AIR_PLACING,
    NO_CLIP,
    HAND_OPENABLE,
    SLAB_PART_BREAKING;

    private static final Map<Player, Integer> settings;

    private int mask() {
        return 1 << this.ordinal();
    }

    public static boolean toggle(Player player, Settings setting) {
        boolean enabled = !Settings.get(player, setting);
        Settings.set(player, setting, enabled);
        return enabled;
    }

    public static void set(Player player, Settings setting, boolean enabled) {
        int mask = setting.mask();
        settings.compute(player, (p, v) -> {
            if (enabled) {
                return (v == null ? 0 : v) | mask;
            }
            return v == null ? null : Integer.valueOf(v & ~mask);
        });
    }

    public static boolean get(Player player, Settings setting) {
        return (settings.getOrDefault(player, 0) & setting.mask()) != 0;
    }

    public static void invalidate(Player player) {
        settings.remove(player);
    }

    public static Stream<Player> getNoClip() {
        return settings.entrySet().stream().filter(entry -> ((Integer)entry.getValue() & NO_CLIP.mask()) != 0).map(Map.Entry::getKey);
    }

    static {
        settings = new ConcurrentHashMap<Player, Integer>();
    }
}

